/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.core;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MapTagSupport;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.BeanSource;
import org.apache.commons.jelly.tags.core.ArgTag;

public class UseBeanTag
extends MapTagSupport
implements BeanSource {
    private Object bean;
    private Class defaultClass;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$core$ArgTag;

    public UseBeanTag() {
    }

    public UseBeanTag(Class defaultClass) {
        this.defaultClass = defaultClass;
    }

    public Object getBean() {
        return this.bean;
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        Map attributes = this.getAttributes();
        String var = (String)attributes.get("var");
        Object classObject = attributes.remove("class");
        try {
            Class theClass = this.convertToClass(classObject);
            this.bean = this.newInstance(theClass, attributes, output);
            this.setBeanProperties(this.bean, attributes);
            this.invokeBody(output);
            this.processBean(var, this.bean);
        }
        catch (ClassNotFoundException e) {
            throw new JellyTagException(e);
        }
    }

    protected void setBean(Object bean) {
        this.bean = bean;
    }

    protected Class convertToClass(Object classObject) throws MissingAttributeException, ClassNotFoundException {
        if (classObject instanceof Class) {
            return (Class)classObject;
        }
        if (classObject == null) {
            Class theClass = this.getDefaultClass();
            if (theClass == null) {
                throw new MissingAttributeException("class");
            }
            return theClass;
        }
        String className = classObject.toString();
        return this.loadClass(className);
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return this.getClass().getClassLoader().loadClass(className);
        }
    }

    protected Object newInstance(Class theClass, Map attributes, XMLOutput output) throws JellyTagException {
        try {
            return theClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new JellyTagException(e.toString());
        }
        catch (InstantiationException e) {
            throw new JellyTagException(e.toString());
        }
    }

    protected void setBeanProperties(Object bean, Map attributes) throws JellyTagException {
        try {
            BeanUtils.populate((Object)bean, (Map)attributes);
        }
        catch (IllegalAccessException e) {
            throw new JellyTagException("could not set the properties of the bean", e);
        }
        catch (InvocationTargetException e) {
            throw new JellyTagException("could not set the properties of the bean", e);
        }
    }

    protected void processBean(String var, Object bean) throws JellyTagException {
        if (var != null) {
            this.context.setVariable(var, bean);
        } else {
            ArgTag parentArg = (ArgTag)this.findAncestorWithClass(class$org$apache$commons$jelly$tags$core$ArgTag == null ? (class$org$apache$commons$jelly$tags$core$ArgTag = UseBeanTag.class$("org.apache.commons.jelly.tags.core.ArgTag")) : class$org$apache$commons$jelly$tags$core$ArgTag);
            if (null != parentArg) {
                parentArg.setValue(bean);
            }
        }
    }

    protected Class getDefaultClass() {
        return this.defaultClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

