/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.util;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;

public class CommandLineParser {
    protected static CommandLineParser _instance = new CommandLineParser();

    public static CommandLineParser getInstance() {
        return _instance;
    }

    public void invokeCommandLineJelly(String[] args) throws JellyException {
        CommandLine cmdLine = null;
        try {
            cmdLine = this.parseCommandLineOptions(args);
        }
        catch (ParseException e) {
            throw new JellyException(e);
        }
        String scriptFile = null;
        scriptFile = cmdLine.hasOption("script") ? cmdLine.getOptionValue("script") : args[0];
        if (!new File(scriptFile).exists()) {
            throw new JellyException("Script file " + scriptFile + " not found");
        }
        try {
            final XMLOutput output = cmdLine.hasOption("o") ? XMLOutput.createXMLOutput(new FileWriter(cmdLine.getOptionValue("o"))) : XMLOutput.createXMLOutput(System.out);
            Jelly jelly = new Jelly();
            jelly.setScript(scriptFile);
            Script script = jelly.compileScript();
            JellyContext context = jelly.getJellyContext();
            context.setVariable("args", args);
            context.setVariable("commandLine", cmdLine);
            script.run(context, output);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception e) {
            throw new JellyException(e);
        }
    }

    public CommandLine parseCommandLineOptions(String[] args) throws ParseException {
        Options cmdLineOptions = new Options();
        cmdLineOptions.addOption("o", true, "Output file");
        cmdLineOptions.addOption("script", true, "Jelly script to run");
        Properties sysProps = System.getProperties();
        ArrayList<String> filteredArgList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-D") && arg.length() > 2) {
                StringTokenizer toks = new StringTokenizer(arg = arg.substring(2), "=");
                if (toks.countTokens() == 2) {
                    sysProps.setProperty(toks.nextToken(), toks.nextToken());
                    continue;
                }
                System.err.println("Invalid system property: " + arg);
                continue;
            }
            filteredArgList.add(arg);
            if (!arg.startsWith("-") || arg.length() <= 1 || arg.equals("-o") && arg.equals("-script")) continue;
            cmdLineOptions.addOption(arg.substring(1, arg.length()), true, "dynamic option");
        }
        String[] filterArgs = new String[filteredArgList.size()];
        filteredArgList.toArray(filterArgs);
        GnuParser parser = new GnuParser();
        return parser.parse(cmdLineOptions, filterArgs);
    }
}

