/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import org.apache.commons.cli.Option;

public class OptionBuilder {
    private static String longopt;
    private static String description;
    private static boolean required;
    private static int numberOfArgs;
    private static Object type;
    private static boolean optionalArg;
    private static char valuesep;
    private static OptionBuilder instance;

    private OptionBuilder() {
    }

    private static void reset() {
        description = null;
        longopt = null;
        type = null;
        required = false;
        numberOfArgs = -1;
    }

    public static OptionBuilder withLongOpt(String longopt) {
        OptionBuilder.longopt = longopt;
        return instance;
    }

    public static OptionBuilder hasArg() {
        numberOfArgs = 1;
        return instance;
    }

    public static OptionBuilder hasArg(boolean hasArg) {
        numberOfArgs = hasArg ? 1 : -1;
        return instance;
    }

    public static OptionBuilder isRequired() {
        required = true;
        return instance;
    }

    public static OptionBuilder withValueSeparator(char sep) {
        valuesep = sep;
        return instance;
    }

    public static OptionBuilder withValueSeparator() {
        valuesep = (char)61;
        return instance;
    }

    public static OptionBuilder isRequired(boolean required) {
        OptionBuilder.required = required;
        return instance;
    }

    public static OptionBuilder hasArgs() {
        numberOfArgs = -2;
        return instance;
    }

    public static OptionBuilder hasArgs(int num) {
        numberOfArgs = num;
        return instance;
    }

    public static OptionBuilder hasOptionalArg() {
        optionalArg = true;
        return instance;
    }

    public static OptionBuilder withType(Object type) {
        OptionBuilder.type = type;
        return instance;
    }

    public static OptionBuilder withDescription(String description) {
        OptionBuilder.description = description;
        return instance;
    }

    public static Option create(char opt) throws IllegalArgumentException {
        return OptionBuilder.create(String.valueOf(opt));
    }

    public static Option create(String opt) throws IllegalArgumentException {
        Option option = new Option(opt, description);
        option.setLongOpt(longopt);
        option.setRequired(required);
        option.setOptionalArg(optionalArg);
        option.setArgs(numberOfArgs);
        option.setType(type);
        option.setValueSeparator(valuesep);
        OptionBuilder.reset();
        return option;
    }

    public static Option create() throws IllegalArgumentException {
        if (longopt == null) {
            throw new IllegalArgumentException("must specify longopt");
        }
        return OptionBuilder.create(" ");
    }

    static {
        numberOfArgs = -1;
        instance = new OptionBuilder();
    }
}

