/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;

public abstract class Parser
implements CommandLineParser {
    private CommandLine cmd;
    private Options options;
    private Map requiredOptions;

    protected abstract String[] flatten(Options var1, String[] var2, boolean var3);

    public CommandLine parse(Options opts, String[] args) throws ParseException {
        return this.parse(opts, args, false);
    }

    public CommandLine parse(Options opts, String[] args, boolean stopAtNonOption) throws ParseException {
        this.options = opts;
        this.requiredOptions = this.options.getRequiredOptions();
        String[] tokens = this.flatten(opts, args, stopAtNonOption);
        List<String> tokenList = Arrays.asList(tokens);
        ListIterator<String> iterator = tokenList.listIterator();
        this.cmd = new CommandLine();
        boolean eatTheRest = false;
        while (iterator.hasNext()) {
            String t = iterator.next();
            if ("--".equals(t)) {
                eatTheRest = true;
            } else if (t.startsWith("-")) {
                if (t.length() == 1) {
                    if (stopAtNonOption) {
                        eatTheRest = true;
                    } else {
                        this.cmd.addArg(t);
                    }
                } else {
                    this.processOption(t, iterator);
                }
            } else {
                this.cmd.addArg(t);
                if (stopAtNonOption) {
                    eatTheRest = true;
                }
            }
            if (!eatTheRest) continue;
            while (iterator.hasNext()) {
                this.cmd.addArg(iterator.next());
            }
        }
        this.checkRequiredOptions();
        return this.cmd;
    }

    private void checkRequiredOptions() throws ParseException {
        if (this.requiredOptions.size() > 0) {
            Iterator iter = this.requiredOptions.values().iterator();
            StringBuffer buff = new StringBuffer();
            while (iter.hasNext()) {
                Option missing = (Option)iter.next();
                buff.append("-");
                buff.append(missing.getOpt());
                buff.append(" ");
                buff.append(missing.getDescription());
            }
            throw new MissingOptionException(buff.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void processArgs(Option opt, ListIterator iter) throws ParseException {
        if (iter.hasNext() || opt.hasOptionalArg()) ** GOTO lbl12
        throw new MissingArgumentException("no argument for:" + opt.getOpt());
lbl-1000:
        // 1 sources

        {
            var = (String)iter.next();
            if (this.options.hasOption(var)) {
                iter.previous();
                break;
            }
            if (opt.addValue(var)) continue;
            iter.previous();
            break;
lbl12:
            // 2 sources

            ** while (iter.hasNext())
        }
lbl13:
        // 3 sources

    }

    private void processOption(String arg, ListIterator iter) throws ParseException {
        Option opt = null;
        boolean hasOption = this.options.hasOption(arg);
        if (!hasOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + arg);
        }
        opt = this.options.getOption(arg);
        if (opt.isRequired()) {
            this.requiredOptions.remove("-" + opt.getOpt());
        }
        if (this.options.getOptionGroup(opt) != null) {
            this.options.getOptionGroup(opt).setSelected(opt);
        }
        if (opt.hasArg()) {
            this.processArgs(opt, iter);
        }
        this.cmd.setOpt(opt);
    }
}

