/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench;

import jp.co.scs.mbench.Benchmark;
import jp.co.scs.mbench.BenchmarkAbortException;
import jp.co.scs.mbench.BenchmarkInfo;
import jp.co.scs.mbench.BenchmarkManager;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.DataWriter;
import jp.co.scs.mbench.LogWriter;
import jp.co.scs.mbench.Synchronizer;
import jp.co.scs.mbench.ThreadTerminateException;

public class BenchmarkContainer
extends Thread {
    public static final String[] SYSTEM_LABELS = new String[]{"ContainerID", "repeatNumber", "startTime", "endTime", "responseTime"};
    protected String currentState = "created";
    protected boolean isInitialized = false;
    private int containerID = 0;
    private BenchmarkInfo info = null;
    private Benchmark benchmark = null;
    private Synchronizer synchronizer = null;
    private long startTime = System.currentTimeMillis();
    private long endTime = System.currentTimeMillis();
    private LogWriter logWriter = null;
    private DataWriter dataWriter = null;
    private int threadIterationCount = 0;

    public BenchmarkContainer(int containerID, BenchmarkInfo info, Synchronizer synchronizer, LogWriter logWriter, DataWriter dataWriter) {
        this.containerID = containerID;
        this.info = info;
        this.synchronizer = synchronizer;
        this.logWriter = logWriter;
        this.dataWriter = dataWriter;
    }

    public int getContainerID() {
        return this.containerID;
    }

    public void setLogWriter(LogWriter logWriter) {
        this.logWriter = logWriter;
    }

    public void setDataWriter(DataWriter dataWriter) {
        this.dataWriter = dataWriter;
    }

    public DataWriter getDataWriter() {
        return this.dataWriter;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public void initTarget() throws BenchmarkTerminateException {
        try {
            this.currentState = "initializing";
            Class<?> benchmarkClass = Class.forName(this.info.getClassName());
            Object benchmarkObject = benchmarkClass.newInstance();
            this.benchmark = (Benchmark)benchmarkObject;
            this.benchmark.setBenchmarkName(this.info.getName());
            this.benchmark.init();
            this.currentState = "initialized";
            this.isInitialized = true;
            this.logWriter.write(1, "[BenchmarkContainer] containerID = " + this.containerID + ", initialize OK");
        }
        catch (ClassNotFoundException ex) {
            this.currentState = "benchmark terminated";
            this.logWriter.write(2, "[BenchmarkContainer] containerID = " + this.containerID + ", initialize ERROR \n" + ex.getMessage());
            throw new BenchmarkTerminateException(ex);
        }
        catch (InstantiationException ex) {
            this.currentState = "benchmark terminated";
            this.logWriter.write(2, "[BenchmarkContainer] containerID = " + this.containerID + ", initialize ERROR \n" + ex.getMessage());
            throw new BenchmarkTerminateException(ex);
        }
        catch (IllegalAccessException ex) {
            this.currentState = "benchmark terminated";
            this.logWriter.write(2, "[BenchmarkContainer] containerID = " + this.containerID + ", initialize ERROR \n" + ex.getMessage());
            throw new BenchmarkTerminateException(ex);
        }
    }

    public void run() {
        this.synchronizer.doSynchronize();
        this.executeTarget();
    }

    public void executeTarget() {
        try {
            this.currentState = "running";
            this.logWriter.write(1, "[BenchmarkContainer] containerID = " + this.containerID + ", execute started");
            while (this.executeCheck()) {
                ++this.threadIterationCount;
                ++BenchmarkManager.allIterationCount;
                this.startTime = System.currentTimeMillis();
                String[] userData = this.benchmark.execute();
                this.endTime = System.currentTimeMillis();
                if (!this.currentState.equals("running")) {
                    return;
                }
                String[] resultData = null;
                if (userData != null) {
                    resultData = new String[SYSTEM_LABELS.length + userData.length];
                    int j = 0;
                    while (j < userData.length) {
                        resultData[BenchmarkContainer.SYSTEM_LABELS.length + j] = userData[j];
                        ++j;
                    }
                } else {
                    resultData = new String[SYSTEM_LABELS.length];
                }
                resultData[0] = String.valueOf(this.containerID);
                resultData[1] = String.valueOf(this.threadIterationCount);
                resultData[2] = String.valueOf(this.startTime - this.info.getBenchmarkStartTime());
                resultData[3] = String.valueOf(this.endTime - this.info.getBenchmarkStartTime());
                resultData[4] = String.valueOf(this.endTime - this.startTime);
                this.dataWriter.write(resultData);
            }
            this.currentState = "finished";
            this.logWriter.write(1, "[BenchmarkContainer] containerID = " + this.containerID + ", execute finished OK");
        }
        catch (ThreadTerminateException ex) {
            this.endTime = -1L;
            this.logWriter.write(2, "[BenchmarkContainer] ThreadTerminate containerID = " + this.containerID + ", iteration = " + this.threadIterationCount);
            this.currentState = "container terminated ";
        }
        catch (BenchmarkTerminateException ex) {
            this.endTime = -1L;
            this.logWriter.write(2, "[BenchmarkContainer] BenchmarkTerminateException containerID = " + this.containerID + ", iteration = " + this.threadIterationCount);
            this.currentState = "benchmark terminated";
        }
    }

    private boolean executeCheck() {
        if (this.threadIterationCount >= this.info.getRepeatNumber()) {
            return false;
        }
        if (this.info.getTransactionNumber() != 0 && BenchmarkManager.allIterationCount >= this.info.getTransactionNumber()) {
            return false;
        }
        return this.info.getBenchmarkEndTime() == 0L || System.currentTimeMillis() - this.info.getBenchmarkStartTime() < this.info.getBenchmarkEndTime() * 1000L;
    }

    public void cleanTarget() throws BenchmarkAbortException {
        this.currentState = "cleaning";
        this.benchmark.clean();
        this.currentState = "cleaned";
        this.logWriter.write(1, "[BenchmarkContainer] containerID = " + this.containerID + ", clean OK");
    }
}

