/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.scs.mbench.Benchmark;
import jp.co.scs.mbench.BenchmarkAbortException;
import jp.co.scs.mbench.BenchmarkContainer;
import jp.co.scs.mbench.BenchmarkInfo;
import jp.co.scs.mbench.BenchmarkManager;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.CSVAsynchronousDataWriter;
import jp.co.scs.mbench.DataWriter;
import jp.co.scs.mbench.DocumentUtil;
import jp.co.scs.mbench.LogWriter;
import jp.co.scs.mbench.MessageResources;
import jp.co.scs.mbench.MultiNodeInfo;
import jp.co.scs.mbench.Synchronizer;
import org.xml.sax.SAXException;

public class BenchmarkManager
extends Thread {
    private Integer managerID = new Integer(1);
    protected String currentState = null;
    private String nodeType = "single";
    private String benchmarkName = null;
    private Map optionMap = null;
    private BenchmarkInfo info = null;
    private BenchmarkContainer[] containers = null;
    private List managedContainers = null;
    private List terminatedContainers = new ArrayList();
    private Synchronizer synchronizer = null;
    private Socket socket = null;
    private Socket[] socketArray = null;
    private final long watchInterval = 100L;
    private long benchmarkTimeout = 300000L;
    private int socketTimeout = 6000;
    private LogWriter logWriter = null;
    private DataWriter dataWriter = null;
    protected static int allIterationCount = 0;

    public BenchmarkManager(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }

    public Integer getManagerID() {
        return this.managerID;
    }

    public void setManagerID(Integer managerID) {
        this.managerID = managerID;
    }

    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    public void setBenchmarkName(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }

    public Map getOptionMap() {
        return this.optionMap;
    }

    public void setOptionMap(Map optionMap) {
        this.optionMap = optionMap;
    }

    public BenchmarkInfo getBenchmarkInfo() {
        return this.info;
    }

    public void setBenchmarkInfo(BenchmarkInfo info) {
        this.info = info;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setLogWriter(LogWriter logWriter) {
        this.logWriter = logWriter;
    }

    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    public void setDataWriter(DataWriter dataWriter) {
        this.dataWriter = dataWriter;
    }

    public DataWriter getDataWriter() {
        return this.dataWriter;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public Synchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setBenchmarkContainers(BenchmarkContainer[] containers) {
        this.containers = containers;
    }

    public BenchmarkContainer[] getBenchmarkContainers() {
        return this.containers;
    }

    public void addTerminatedContainer(BenchmarkContainer container) {
        this.terminatedContainers.add(container);
    }

    public List getTerminatedContainers() {
        return this.terminatedContainers;
    }

    public void setBenchmarkTimeout(long benchmarkTimeout) {
        this.benchmarkTimeout = benchmarkTimeout;
    }

    public long getBenchmarkTimeout() {
        return this.benchmarkTimeout;
    }

    public void run() {
        this.currentState = "created";
        Date currentDate = Calendar.getInstance().getTime();
        String pattern = "yyyyMMdd_HHmmss";
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        String suffix = dateFormat.format(currentDate);
        try {
            if (this.logWriter == null) {
                String logName = "log_" + suffix + ".log";
                this.logWriter = new LogWriter(logName);
            }
            this.logWriter.init();
            if (this.dataWriter == null) {
                String dataName = "data_" + suffix + ".csv";
                this.dataWriter = new CSVAsynchronousDataWriter(dataName);
            }
            this.logWriter.write(1, MessageResources.getMessage("BenchmarkManager.start", this.managerID));
        }
        catch (BenchmarkTerminateException ex) {
            this.currentState = "benchmark fail";
            throw new BenchmarkAbortException(ex);
        }
        this.currentState = "initializing";
        try {
            this.doInit();
        }
        catch (BenchmarkTerminateException ex) {
            if (this.nodeType.equals("primary")) {
                this.notifyInitFailureAsPrimary();
            } else if (this.nodeType.equals("secondary")) {
                this.notifyInitFailureAsSecondary();
            }
            this.currentState = "cleaning";
            this.doClean();
            this.logWriter.write(1, MessageResources.getMessage("BenchmarkManager.ng", this.managerID));
            this.logWriter.clean();
            this.dataWriter.clean();
            this.currentState = "cleaned";
            this.currentState = "benchmark fail";
            return;
        }
        this.currentState = "initialized";
        try {
            if (this.nodeType.equals("primary")) {
                this.checkInitAsPrimary();
            } else if (this.nodeType.equals("secondary")) {
                this.checkInitAsSecondary();
            }
        }
        catch (BenchmarkTerminateException ex) {
            this.currentState = "cleaning";
            this.doClean();
            this.logWriter.write(1, MessageResources.getMessage("BenchmarkManager.ng", this.managerID));
            this.logWriter.clean();
            this.dataWriter.clean();
            this.currentState = "cleaned";
            this.currentState = "benchmark fail";
            return;
        }
        this.currentState = "running";
        try {
            if (this.nodeType.equals("primary")) {
                this.synchronizeMultiNodeAsPrimary();
            } else if (this.nodeType.equals("secondary")) {
                this.synchronizeMultiNodeAsSecondary();
            }
            this.doRun();
        }
        catch (BenchmarkTerminateException ex) {
            this.killManagedContainers();
            this.currentState = "cleaning";
            this.doClean();
            this.logWriter.write(1, MessageResources.getMessage("BenchmarkManager.ng", this.managerID));
            this.logWriter.clean();
            this.dataWriter.clean();
            this.currentState = "cleaned";
            this.currentState = "benchmark fail";
            return;
        }
        this.currentState = "finished";
        this.currentState = "cleaning";
        this.doClean();
        this.logWriter.write(1, MessageResources.getMessage("BenchmarkManager.ok", this.managerID));
        this.logWriter.clean();
        this.dataWriter.clean();
        try {
            if (this.socketArray != null) {
                int i = 0;
                while (i < this.socketArray.length) {
                    this.socketArray[i].close();
                    ++i;
                }
            }
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.currentState = "created";
        this.currentState = "benchmark success";
    }

    protected void doInit() throws BenchmarkTerminateException {
        try {
            if (this.info == null) {
                this.info = DocumentUtil.getBenchmarkInfo(this.benchmarkName);
            }
            if (this.optionMap != null && this.optionMap.get("multi-client") != null) {
                this.checkMultiNodeConnect((String)this.optionMap.get("multi-client"));
            }
            this.overRideInfo(this.optionMap);
            Object[] items = new Object[]{new Integer(this.info.getThreadNumber()), new Integer(this.info.getRepeatNumber()), new Integer(this.info.getTransactionNumber()), new Long(this.info.getBenchmarkEndTime()), this.info.getClassName(), this.nodeType};
            this.logWriter.write(1, MessageResources.getMessage("BenchmarkManager.configuration", items));
            this.dataWriter.init();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Class<?> benchmarkClass = Class.forName(this.info.getClassName());
            Object benchmarkObject = benchmarkClass.newInstance();
            String[] userLabels = ((Benchmark)benchmarkObject).getOptionLabels();
            if (userLabels != null) {
                String[] resultLabels = new String[BenchmarkContainer.SYSTEM_LABELS.length + userLabels.length];
                int i = 0;
                while (i < BenchmarkContainer.SYSTEM_LABELS.length) {
                    resultLabels[i] = BenchmarkContainer.SYSTEM_LABELS[i];
                    ++i;
                }
                i = 0;
                while (i < userLabels.length) {
                    resultLabels[BenchmarkContainer.SYSTEM_LABELS.length + i] = userLabels[i];
                    ++i;
                }
                this.dataWriter.write(resultLabels);
            } else {
                this.dataWriter.write(BenchmarkContainer.SYSTEM_LABELS);
            }
            if (this.synchronizer == null) {
                this.synchronizer = new Synchronizer();
            }
            if (this.containers == null) {
                this.containers = new BenchmarkContainer[this.info.getThreadNumber()];
                int i = 0;
                while (i < this.containers.length) {
                    int containerID = i + 1;
                    this.containers[i] = new BenchmarkContainer(containerID, this.info, this.synchronizer, this.logWriter, this.dataWriter);
                    ++i;
                }
            }
            int i = 0;
            while (i < this.containers.length) {
                this.containers[i].initTarget();
                ++i;
            }
            this.synchronizer.start();
            i = 0;
            while (i < this.containers.length) {
                this.containers[i].start();
                ++i;
            }
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
        catch (ParserConfigurationException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
        catch (SAXException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
        catch (IllegalArgumentException ex) {
            this.logWriter.write(2, "[BenchmarkManager] " + ex.getMessage());
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
        catch (ClassNotFoundException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
        catch (InstantiationException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
        catch (IllegalAccessException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
        catch (BenchmarkTerminateException ex) {
            this.currentState = "benchmark terminated";
            throw ex;
        }
    }

    protected void doRun() throws BenchmarkTerminateException {
        this.info.setBenchmarkStartTime(System.currentTimeMillis());
        this.synchronizer.interrupt();
        this.managedContainers = new LinkedList();
        int i = 0;
        while (i < this.containers.length) {
            this.managedContainers.add(this.containers[i]);
            ++i;
        }
        while (this.managedContainers.size() > 0) {
            i = 0;
            while (i < this.managedContainers.size()) {
                BenchmarkContainer container = (BenchmarkContainer)this.managedContainers.get(i);
                if (container.getCurrentState().equals("running")) {
                    long currentTime;
                    long progressTime;
                    if (this.benchmarkTimeout > 0L && (progressTime = (currentTime = System.currentTimeMillis()) - container.getStartTime()) > this.benchmarkTimeout) {
                        container.stop();
                        this.addTerminatedContainer(container);
                        this.managedContainers.remove(container);
                        this.logWriter.write(2, MessageResources.getMessage("BenchmarkManager.timeout", new Integer(container.getContainerID()), (Object)new Long(this.benchmarkTimeout)));
                    }
                } else if (container.getCurrentState().equals("finished")) {
                    this.managedContainers.remove(container);
                } else if (container.getCurrentState().equals("container terminated ")) {
                    this.managedContainers.remove(container);
                } else if (container.getCurrentState().equals("benchmark terminated")) {
                    this.currentState = "benchmark terminated";
                    if (this.nodeType.equals("primary")) {
                        this.notifyRunFailureAsPrimary();
                    } else if (this.nodeType.equals("secondary")) {
                        this.notifyRunFailureAsSecondary();
                    }
                    throw new BenchmarkTerminateException();
                }
                ++i;
            }
            if (this.nodeType.equals("primary")) {
                this.checkRunFailureAsPrimary();
            } else if (this.nodeType.equals("secondary")) {
                this.checkRunFailureAsSecondary();
            }
            if (this.managedContainers.size() <= 0) continue;
            try {
                Thread.sleep(this.watchInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void doClean() {
        if (this.containers != null) {
            int i = 0;
            while (i < this.containers.length) {
                if (this.containers[i].isInitialized()) {
                    this.containers[i].cleanTarget();
                }
                ++i;
            }
        }
    }

    protected void checkMultiNodeConnect(String name) {
        try {
            MultiNodeInfo info = DocumentUtil.getMultiNodeInfo(name);
            this.nodeType = info.getNodeType();
            if (this.nodeType.equalsIgnoreCase("primary")) {
                this.checkConnectAsPrimary(info);
            } else if (this.nodeType.equalsIgnoreCase("secondary")) {
                this.checkConnectAsSecondary(info);
            }
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException(ex);
        }
        catch (ParserConfigurationException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException(ex);
        }
        catch (SAXException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException(ex);
        }
    }

    protected void checkConnectAsPrimary(MultiNodeInfo info) {
        block15: {
            try {
                int[] targetPort = info.getSecondaryPort();
                String[] targetHost = info.getSecondaryHost();
                int localPort = info.getLocalPort();
                InetAddress localAddress = InetAddress.getByName(info.getLocalHost());
                this.socketArray = new Socket[targetHost.length];
                int maxRetry = 10;
                int successSocketCount = 0;
                int i = 0;
                while (i < maxRetry) {
                    int j22 = 0;
                    while (j22 < info.getSecondaryHost().length) {
                        if (this.socketArray[j22] == null) {
                            try {
                                this.socketArray[j22] = new Socket(targetHost[j22], targetPort[j22]);
                                this.socketArray[j22].setSoTimeout(this.socketTimeout);
                                ++successSocketCount;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        ++j22;
                    }
                    if (successSocketCount == targetHost.length) break;
                    try {
                        Thread.sleep(this.socketTimeout / maxRetry);
                    }
                    catch (InterruptedException j22) {
                        // empty catch block
                    }
                    ++i;
                }
                try {
                    if (successSocketCount == targetHost.length) {
                        int managerIDOffset = this.managerID;
                        int i2 = 0;
                        while (i2 < successSocketCount) {
                            OutputStream os = this.socketArray[i2].getOutputStream();
                            String message = "doInit" + (managerIDOffset += this.info.getThreadNumber());
                            os.write(new String(message).getBytes());
                            ++i2;
                        }
                        break block15;
                    }
                    i = 0;
                    while (i < targetHost.length) {
                        if (this.socketArray[i] != null) {
                            OutputStream os = this.socketArray[i].getOutputStream();
                            os.write(new String("doAbort").getBytes());
                        }
                        ++i;
                    }
                    this.currentState = "benchmark fail";
                    throw new BenchmarkAbortException();
                }
                catch (IOException ex) {
                    this.currentState = "benchmark fail";
                    throw new BenchmarkAbortException(ex);
                }
            }
            catch (UnknownHostException ex) {
                this.currentState = "benchmark fail";
                throw new BenchmarkAbortException(ex);
            }
        }
    }

    protected void checkConnectAsSecondary(MultiNodeInfo info) {
        try {
            int localPort = info.getLocalPort();
            int backlog = 1;
            InetAddress localAddress = InetAddress.getByName(info.getLocalHost());
            ServerSocket server = new ServerSocket(localPort, backlog, localAddress);
            server.setSoTimeout(this.socketTimeout);
            this.socket = server.accept();
            this.socket.setSoTimeout(this.socketTimeout);
            byte[] buffer = new byte[20];
            InputStream is = this.socket.getInputStream();
            is.read(buffer);
            String message = new String(this.trimBlankByte(buffer));
            if (message.startsWith("doInit")) {
                String managerIDString = message.substring(6, message.length());
                int newManagerID = Integer.parseInt(managerIDString);
                this.managerID = new Integer(newManagerID);
                return;
            }
            String errMsg = "aborting";
            this.currentState = "benchmark fail";
            throw new BenchmarkAbortException(errMsg);
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            this.currentState = "benchmark fail";
            throw new BenchmarkAbortException(ex);
        }
        catch (SocketTimeoutException ex) {
            this.currentState = "benchmark fail";
            throw new BenchmarkAbortException(ex);
        }
        catch (IOException ex) {
            this.currentState = "benchmark fail";
            throw new BenchmarkAbortException(ex);
        }
    }

    protected void checkInitAsPrimary() throws BenchmarkTerminateException {
        try {
            OutputStream os;
            boolean allSecondariesOK = true;
            int i = 0;
            while (i < this.socketArray.length) {
                InputStream is = this.socketArray[i].getInputStream();
                byte[] buffer = new byte[20];
                is.read(buffer);
                buffer = this.trimBlankByte(buffer);
                String message = new String(this.trimBlankByte(buffer));
                if (!message.equals("doInit OK")) {
                    allSecondariesOK = false;
                    break;
                }
                ++i;
            }
            if (allSecondariesOK) {
                i = 0;
                while (i < this.socketArray.length) {
                    os = this.socketArray[i].getOutputStream();
                    os.write(new String("doRun").getBytes());
                    ++i;
                }
                return;
            }
            i = 0;
            while (i < this.socketArray.length) {
                os = this.socketArray[i].getOutputStream();
                os.write(new String("doTerminate").getBytes());
                ++i;
            }
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException("terminating");
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException("terminating");
        }
    }

    protected void checkInitAsSecondary() throws BenchmarkTerminateException {
        try {
            OutputStream os = this.socket.getOutputStream();
            os.write(new String("doInit OK").getBytes());
            InputStream is = this.socket.getInputStream();
            byte[] buffer = new byte[20];
            is.read(buffer);
            String message = new String(this.trimBlankByte(buffer));
            if (message.equals("doRun")) {
                return;
            }
            throw new BenchmarkTerminateException(message);
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
    }

    protected void notifyInitFailureAsSecondary() {
        try {
            OutputStream os = this.socket.getOutputStream();
            os.write(new String("ERROR:init").getBytes());
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException();
        }
    }

    protected void notifyInitFailureAsPrimary() {
        try {
            int i = 0;
            while (i < this.socketArray.length) {
                OutputStream os = this.socketArray[i].getOutputStream();
                os.write(new String("ERROR:init").getBytes());
                ++i;
            }
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException();
        }
    }

    protected void notifyRunFailureAsSecondary() {
        try {
            OutputStream os = this.socket.getOutputStream();
            os.write(new String("ERROR:run").getBytes());
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException();
        }
    }

    protected void notifyRunFailureAsPrimary() {
        try {
            int i = 0;
            while (i < this.socketArray.length) {
                OutputStream os = this.socketArray[i].getOutputStream();
                os.write(new String("ERROR:run").getBytes());
                ++i;
            }
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException();
        }
    }

    protected void synchronizeMultiNodeAsSecondary() throws BenchmarkTerminateException {
        try {
            InputStream is = this.socket.getInputStream();
            byte[] readBuffer = new byte[10];
            is.read(readBuffer);
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkTerminateException(ex);
        }
    }

    protected void synchronizeMultiNodeAsPrimary() {
        Synchronizer lock = new Synchronizer();
        lock.start();
        int i = 0;
        while (i < this.socketArray.length) {
            class Trigger
            extends Thread {
                private Synchronizer sync;
                private Socket socket;
                final /* synthetic */ BenchmarkManager this$0;

                public Trigger(BenchmarkManager benchmarkManager, Synchronizer sync, Socket socket) {
                    this.this$0 = benchmarkManager;
                    this.sync = null;
                    this.socket = null;
                    this.sync = sync;
                    this.socket = socket;
                }

                public void run() {
                    try {
                        OutputStream os = this.socket.getOutputStream();
                        byte[] writeBuffer = new String("start").getBytes();
                        this.sync.doSynchronize();
                        os.write(writeBuffer);
                    }
                    catch (IOException ex) {
                        throw new BenchmarkAbortException();
                    }
                }
            }
            new Trigger(this, lock, this.socketArray[i]).start();
            ++i;
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        lock.interrupt();
    }

    protected void checkRunFailureAsPrimary() throws BenchmarkTerminateException {
        try {
            int i = 0;
            while (i < this.socketArray.length) {
                byte[] readBuffer = new byte[20];
                InputStream is = this.socketArray[i].getInputStream();
                this.socketArray[i].setSoTimeout(1);
                try {
                    is.read(readBuffer);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    // empty catch block
                }
                this.socketArray[i].setSoTimeout(this.socketTimeout);
                String message = new String(readBuffer);
                if (message.equals("ERROR:run")) {
                    throw new BenchmarkTerminateException();
                }
                ++i;
            }
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException();
        }
    }

    protected void checkRunFailureAsSecondary() throws BenchmarkTerminateException {
        try {
            byte[] readBuffer = new byte[20];
            InputStream is = this.socket.getInputStream();
            this.socket.setSoTimeout(1);
            try {
                is.read(readBuffer);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
            this.socket.setSoTimeout(this.socketTimeout);
            String message = new String(this.trimBlankByte(readBuffer));
            if (message.equals("ERROR:run")) {
                throw new BenchmarkTerminateException();
            }
        }
        catch (IOException ex) {
            this.currentState = "benchmark terminated";
            throw new BenchmarkAbortException();
        }
    }

    private void killManagedContainers() {
        int j = 0;
        while (j < this.managedContainers.size()) {
            BenchmarkContainer leftContainer = (BenchmarkContainer)this.managedContainers.get(j);
            leftContainer.stop();
            this.addTerminatedContainer(leftContainer);
            this.logWriter.write(1, MessageResources.getMessage("BenchmarkManager.terminate", new Integer(leftContainer.getContainerID())));
            ++j;
        }
        this.managedContainers.clear();
    }

    private void overRideInfo(Map optionMap) {
        String benchmarkEndTime;
        String txNumber;
        String repeatNumber;
        if (optionMap == null || optionMap.size() == 0) {
            return;
        }
        String threadNumber = (String)optionMap.get("threadNumber");
        if (threadNumber != null) {
            this.info.setThreadNumber(Integer.parseInt(threadNumber));
        }
        if ((repeatNumber = (String)optionMap.get("repeatNumber")) != null) {
            this.info.setRepeatNumber(Integer.parseInt(repeatNumber));
        }
        if ((txNumber = (String)optionMap.get("transactionNumber")) != null) {
            this.info.setTransactionNumber(Integer.parseInt(txNumber));
        }
        if ((benchmarkEndTime = (String)optionMap.get("benchmarkEndTime")) != null) {
            this.info.setBenchmarkEndTime(Long.parseLong(benchmarkEndTime));
        }
    }

    private byte[] trimBlankByte(byte[] buffer) {
        int count = 0;
        int i = 0;
        while (i < buffer.length) {
            if (buffer[i] == 0) break;
            ++count;
            ++i;
        }
        byte[] newBuffer = new byte[count];
        int i2 = 0;
        while (i2 < count) {
            newBuffer[i2] = buffer[i2];
            ++i2;
        }
        return newBuffer;
    }
}

