/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.DataWriter;

public class CSVAsynchronousDataWriter
extends Thread
implements DataWriter {
    private String dataName = null;
    private BufferedWriter writer = null;
    private boolean isInitialized = false;
    private boolean isRunning = false;
    private LinkedList dataQueue = new LinkedList();
    private int remove = 0;
    private int add = 1;

    public CSVAsynchronousDataWriter(String dataName) {
        this.dataName = dataName;
    }

    public void setDataName(String dataName) {
        this.dataName = dataName;
    }

    public String getDataName() {
        return this.dataName;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getDataQueueSize() {
        return this.dataQueue.size();
    }

    public void init() throws BenchmarkTerminateException {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.dataName));
            this.start();
            this.isInitialized = true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new BenchmarkTerminateException(ex);
        }
    }

    public void write(String[] data) {
        this.manipulateQueue(this.add, data);
    }

    public void run() {
        try {
            this.isRunning = true;
            while (this.isRunning || this.dataQueue.size() > 0) {
                Object obj = this.manipulateQueue(this.remove, null);
                if (obj != null) {
                    String[] data = (String[])obj;
                    int i = 0;
                    while (i < data.length) {
                        this.writer.write(data[i]);
                        if (i < data.length - 1) {
                            this.writer.write(",");
                        }
                        ++i;
                    }
                    this.writer.write("\n");
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        catch (IOException ex) {
            this.isRunning = false;
            this.isInitialized = false;
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clean() {
        try {
            try {
                while (true) {
                    block9: {
                        if (this.isInitialized && this.dataQueue.size() > 0) break block9;
                        this.isRunning = false;
                        if (this.writer != null) {
                            this.writer.close();
                        }
                        break;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.isInitialized = false;
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.isInitialized = false;
            return;
        }
    }

    private synchronized Object manipulateQueue(int command, Object obj) {
        if (command == this.add) {
            this.dataQueue.addLast(obj);
            return null;
        }
        if (command == this.remove) {
            if (this.dataQueue.size() > 0) {
                return this.dataQueue.removeFirst();
            }
            return null;
        }
        return null;
    }
}

