/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.scs.mbench.BenchmarkInfo;
import jp.co.scs.mbench.FinalizerInfo;
import jp.co.scs.mbench.InitializerInfo;
import jp.co.scs.mbench.MultiNodeInfo;
import jp.co.scs.mbench.jdbc.DataSourceInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentUtil {
    private static final String CONFIGURATION_FILE_NAME = "conf/mbench.xml";
    private static final String FILE_ENCODING = System.getProperty("file.encoding");

    public static Document getDocument() throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getDocument(CONFIGURATION_FILE_NAME, FILE_ENCODING);
    }

    public static Document getDocument(String fileName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getDocument(fileName, FILE_ENCODING);
    }

    public static Document getDocument(String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        File xmlFile = new File(fileName);
        String uri = xmlFile.toURL().toString();
        FileInputStream istream = new FileInputStream(xmlFile);
        InputSource is = new InputSource(new InputStreamReader((InputStream)istream, encoding));
        is.setSystemId(uri);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.parse(is);
        ((InputStream)istream).close();
        return document;
    }

    public static InitializerInfo getInitializerInfo(String initializerName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getInitializerInfo(initializerName, CONFIGURATION_FILE_NAME, FILE_ENCODING);
    }

    public static InitializerInfo getInitializerInfo(String initializerName, String fileName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getInitializerInfo(initializerName, fileName, FILE_ENCODING);
    }

    public static InitializerInfo getInitializerInfo(String initializerName, String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        InitializerInfo[] infoArray = DocumentUtil.getInitializerInfoArray(fileName, encoding);
        int i = 0;
        while (i < infoArray.length) {
            if (infoArray[i].getName().equalsIgnoreCase(initializerName)) {
                return infoArray[i];
            }
            ++i;
        }
        throw new IllegalArgumentException(String.valueOf(initializerName) + " is not found.");
    }

    public static DataSourceInfo getDataSourceInfo(String dataSourceName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getDataSourceInfo(dataSourceName, CONFIGURATION_FILE_NAME, FILE_ENCODING);
    }

    public static DataSourceInfo getDataSourceInfo(String dataSourceName, String fileName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getDataSourceInfo(dataSourceName, fileName, FILE_ENCODING);
    }

    public static DataSourceInfo getDataSourceInfo(String dataSourceName, String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        Node targetNode = DocumentUtil.getDataSourceNode(dataSourceName, fileName, encoding);
        DataSourceInfo info = new DataSourceInfo();
        info.setName(dataSourceName);
        NodeList childNodes = targetNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeName().equalsIgnoreCase("protocol")) {
                info.setProtocol(childNode.getFirstChild().getNodeValue());
            } else if (childNode.getNodeName().equalsIgnoreCase("driver")) {
                info.setDriver(childNode.getFirstChild().getNodeValue());
            } else if (childNode.getNodeName().equalsIgnoreCase("host")) {
                info.setHost(childNode.getFirstChild().getNodeValue());
            } else if (childNode.getNodeName().equalsIgnoreCase("port")) {
                info.setPort(childNode.getFirstChild().getNodeValue());
            } else if (childNode.getNodeName().equalsIgnoreCase("db")) {
                info.setDB(childNode.getFirstChild().getNodeValue());
            } else if (childNode.getNodeName().equalsIgnoreCase("user")) {
                info.setUser(childNode.getFirstChild().getNodeValue());
            } else if (childNode.getNodeName().equalsIgnoreCase("password")) {
                info.setPassword(childNode.getFirstChild().getNodeValue());
            }
            ++i;
        }
        return info;
    }

    public static BenchmarkInfo getBenchmarkInfo(String benchmarkName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getBenchmarkInfo(benchmarkName, CONFIGURATION_FILE_NAME, FILE_ENCODING);
    }

    public static BenchmarkInfo getBenchmarkInfo(String benchmarkName, String fileName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getBenchmarkInfo(benchmarkName, fileName, FILE_ENCODING);
    }

    public static BenchmarkInfo getBenchmarkInfo(String benchmarkName, String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        BenchmarkInfo[] info = DocumentUtil.getBenchmarkInfoArray(fileName, encoding);
        int i = 0;
        while (i < info.length) {
            if (info[i].getName().equalsIgnoreCase(benchmarkName)) {
                return info[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("benchmark not found named : " + benchmarkName);
    }

    public static MultiNodeInfo getMultiNodeInfo(String name) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getMultiNodeInfo(name, CONFIGURATION_FILE_NAME, FILE_ENCODING);
    }

    public static MultiNodeInfo getMultiNodeInfo(String name, String fileName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getMultiNodeInfo(name, fileName, FILE_ENCODING);
    }

    public static MultiNodeInfo getMultiNodeInfo(String name, String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        Document document = DocumentUtil.getDocument(fileName, encoding);
        NodeList candidateList = document.getElementsByTagName("multi-client");
        int i = 0;
        while (i < candidateList.getLength()) {
            Element element = (Element)candidateList.item(i);
            String candidateName = element.getAttribute("name");
            if (candidateName != null && candidateName.equalsIgnoreCase(name)) {
                MultiNodeInfo info = new MultiNodeInfo();
                info.setName(name);
                String type = element.getAttribute("type");
                if (type == null) {
                    throw new IllegalArgumentException("type for multi-client is not defined named " + name);
                }
                if (type.equalsIgnoreCase("primary")) {
                    info.setNodeType("primary");
                } else if (type.equalsIgnoreCase("secondary")) {
                    info.setNodeType("secondary");
                } else {
                    throw new IllegalArgumentException("illegal type for multi-client named " + name + " : " + type);
                }
                if (element.getAttribute("host") != null) {
                    info.setLocalHost(element.getAttribute("host"));
                }
                if (element.getAttribute("port") != null) {
                    info.setLocalPort(Integer.parseInt(element.getAttribute("port")));
                }
                if (info.getNodeType().equals("primary")) {
                    NodeList secondaryList = element.getElementsByTagName("secondary");
                    if (secondaryList.getLength() < 1) {
                        throw new IllegalArgumentException("secondary is not defined for " + name);
                    }
                    String[] secondaryHost = new String[secondaryList.getLength()];
                    int[] secondaryPort = new int[secondaryList.getLength()];
                    info.setSecondaryHost(secondaryHost);
                    info.setSecondaryPort(secondaryPort);
                    int j = 0;
                    while (j < secondaryList.getLength()) {
                        Element secondary = (Element)secondaryList.item(j);
                        secondaryHost[j] = secondary.getAttribute("host") != null ? secondary.getAttribute("host") : "localhost";
                        secondaryPort[j] = secondary.getAttribute("port") != null ? Integer.parseInt(secondary.getAttribute("port")) : 2826;
                        ++j;
                    }
                }
                return info;
            }
            ++i;
        }
        throw new IllegalArgumentException("multi node infomation for " + name + " is not found");
    }

    public static FinalizerInfo getFinalizerInfo(String finalizerName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getFinalizerInfo(finalizerName, CONFIGURATION_FILE_NAME, FILE_ENCODING);
    }

    public static FinalizerInfo getFinalizerInfo(String finalizerName, String fileName) throws IOException, ParserConfigurationException, SAXException {
        return DocumentUtil.getFinalizerInfo(finalizerName, fileName, FILE_ENCODING);
    }

    public static FinalizerInfo getFinalizerInfo(String finalizerName, String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        FinalizerInfo[] infoArray = DocumentUtil.getFinalizerInfoArray(fileName, encoding);
        int i = 0;
        while (i < infoArray.length) {
            if (infoArray[i].getName().equalsIgnoreCase(finalizerName)) {
                return infoArray[i];
            }
            ++i;
        }
        throw new IllegalArgumentException(String.valueOf(finalizerName) + " is not found.");
    }

    private static InitializerInfo[] getInitializerInfoArray(String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        Document document = DocumentUtil.getDocument(fileName, encoding);
        Element rootElement = document.getDocumentElement();
        NodeList nodeList = rootElement.getElementsByTagName("initializer");
        InitializerInfo[] infoArray = new InitializerInfo[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            NamedNodeMap attributeMap = node.getAttributes();
            Node nameNode = attributeMap.getNamedItem("name");
            infoArray[i] = new InitializerInfo();
            infoArray[i].setName(nameNode.getNodeValue());
            Node typeNode = attributeMap.getNamedItem("type");
            NodeList childNodeList = node.getChildNodes();
            int j = 0;
            while (j < childNodeList.getLength()) {
                Node childNode = childNodeList.item(j);
                if (childNode.getNodeName().equalsIgnoreCase("class")) {
                    infoArray[i].setClassName(childNode.getFirstChild().getNodeValue());
                    break;
                }
                ++j;
            }
            ++i;
        }
        return infoArray;
    }

    private static Node getDataSourceNode(String databaseName, String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        Document document = DocumentUtil.getDocument(fileName, encoding);
        Element rootElement = document.getDocumentElement();
        NodeList nodeList = document.getElementsByTagName("datasource");
        Node targetNode = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node candidateNode = nodeList.item(i);
            NamedNodeMap attributeMap = candidateNode.getAttributes();
            Node nameNode = attributeMap.getNamedItem("name");
            if (nameNode.getNodeValue().equalsIgnoreCase(databaseName)) {
                targetNode = candidateNode;
                break;
            }
            ++i;
        }
        if (targetNode == null) {
            throw new IllegalArgumentException("databaseName : " + databaseName + " is not found in XML document.");
        }
        return targetNode;
    }

    private static BenchmarkInfo[] getBenchmarkInfoArray(String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        Document document = DocumentUtil.getDocument(fileName, encoding);
        Element rootElement = document.getDocumentElement();
        NodeList nodeList = rootElement.getElementsByTagName("benchmark");
        BenchmarkInfo[] infoArray = new BenchmarkInfo[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            NamedNodeMap attributeMap = node.getAttributes();
            Node nameNode = attributeMap.getNamedItem("name");
            infoArray[i] = new BenchmarkInfo();
            infoArray[i].setName(nameNode.getNodeValue());
            NodeList childNodeList = node.getChildNodes();
            int j = 0;
            while (j < childNodeList.getLength()) {
                Node childNode = childNodeList.item(j);
                if (childNode.getNodeName().equalsIgnoreCase("class")) {
                    infoArray[i].setClassName(childNode.getFirstChild().getNodeValue());
                    break;
                }
                ++j;
            }
            ++i;
        }
        return infoArray;
    }

    private static FinalizerInfo[] getFinalizerInfoArray(String fileName, String encoding) throws IOException, ParserConfigurationException, SAXException {
        Document document = DocumentUtil.getDocument(fileName, encoding);
        Element rootElement = document.getDocumentElement();
        NodeList nodeList = rootElement.getElementsByTagName("finalizer");
        FinalizerInfo[] infoArray = new FinalizerInfo[nodeList.getLength()];
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            NamedNodeMap attributeMap = node.getAttributes();
            Node nameNode = attributeMap.getNamedItem("name");
            infoArray[i] = new FinalizerInfo();
            infoArray[i].setName(nameNode.getNodeValue());
            Node typeNode = attributeMap.getNamedItem("type");
            NodeList childNodeList = node.getChildNodes();
            int j = 0;
            while (j < childNodeList.getLength()) {
                Node childNode = childNodeList.item(j);
                if (childNode.getNodeName().equalsIgnoreCase("class")) {
                    infoArray[i].setClassName(childNode.getFirstChild().getNodeValue());
                    break;
                }
                ++j;
            }
            ++i;
        }
        return infoArray;
    }
}

