/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import jp.co.scs.mbench.BenchmarkAbortException;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.DocumentUtil;
import jp.co.scs.mbench.Finalizer;
import jp.co.scs.mbench.FinalizerInfo;
import org.xml.sax.SAXException;

public class FinalizeManager {
    private String finalizerName = null;
    private Finalizer finalizer = null;

    public FinalizeManager(String finalizerName) {
        this.finalizerName = finalizerName;
    }

    public String getFinalizerName() {
        return this.finalizerName;
    }

    public void setFinalizerName(String finalizerName) {
        this.finalizerName = finalizerName;
    }

    public Finalizer getFinalizer() {
        return this.finalizer;
    }

    public void setFinalizer(Finalizer finalizer) {
        this.finalizer = finalizer;
    }

    public void execute() throws BenchmarkTerminateException {
        try {
            FinalizerInfo info = DocumentUtil.getFinalizerInfo(this.finalizerName);
            this.finalizer = this.getFinalizer(info);
            this.finalizer.setFinalizerName(this.finalizerName);
            this.finalizer.execute();
            System.out.println("finalize done ... " + this.finalizerName);
        }
        catch (BenchmarkAbortException ex) {
            throw new BenchmarkTerminateException(ex);
        }
        catch (IOException ex) {
            throw new BenchmarkTerminateException();
        }
        catch (ParserConfigurationException ex) {
            throw new BenchmarkTerminateException();
        }
        catch (SAXException ex) {
            throw new BenchmarkTerminateException();
        }
    }

    public Finalizer getFinalizer(FinalizerInfo info) {
        try {
            Class<?> classObject = Class.forName(info.getClassName());
            return (Finalizer)classObject.newInstance();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new BenchmarkAbortException("can't get the class : " + info.getClassName());
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
            throw new BenchmarkAbortException("can't get the class : " + info.getClassName());
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new BenchmarkAbortException("can't get the class : " + info.getClassName());
        }
    }
}

