/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench.component;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import jp.co.scs.mbench.Benchmark;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.ThreadTerminateException;
import jp.co.scs.mbench.jdbc.DataSourceManager;

public class Connect01Benchmark
implements Benchmark {
    private static int conCount = 0;
    private String benchmarkName = null;
    private String[] optionLabels = new String[]{"status", "primary-key", "value", "retry"};
    private DataSource dataSource = null;
    private Connection con = null;
    private Statement stmt = null;
    private int reconnectNumber = 0;
    private final int waitTime = 3000;
    private final int reconnectLimitNumber = 1000;

    public String getBenchmarkName() {
        return this.benchmarkName;
    }

    public void setBenchmarkName(String benchmarkName) {
        this.benchmarkName = benchmarkName;
    }

    public String[] getOptionLabels() {
        return this.optionLabels;
    }

    public void setOptionLabels(String[] optionLabels) {
        this.optionLabels = optionLabels;
    }

    public void init() throws BenchmarkTerminateException {
        try {
            this.dataSource = conCount % 2 == 0 ? DataSourceManager.getDataSource("mysql_con1") : DataSourceManager.getDataSource("mysql_con2");
            this.con = this.dataSource.getConnection();
            ++conCount;
            this.stmt = this.con.createStatement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new BenchmarkTerminateException(ex);
        }
    }

    public String[] execute() throws ThreadTerminateException {
        int key = (int)Math.round(100.0 * Math.random() + 0.5);
        return this.doExecute(key);
    }

    public void clean() {
        try {
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String[] doExecute(int key) throws ThreadTerminateException {
        try {
            String q1 = "select c2 from t1 where c1 = " + key;
            this.con.setAutoCommit(false);
            this.con.setTransactionIsolation(2);
            ResultSet rs = this.stmt.executeQuery(q1);
            rs.next();
            int value = rs.getInt("c2");
            this.con.commit();
            return new String[]{"commit", String.valueOf(key), String.valueOf(value), String.valueOf(this.reconnectNumber)};
        }
        catch (SQLException ex) {
            String sqlState = ex.getSQLState();
            if (sqlState.equals("08S01")) {
                System.out.println("Reconnect START");
                this.doReconnect();
                System.out.println("Reconnect OK");
                return this.doExecute(key);
            }
            if (!sqlState.equals("08S01") && this.con != null) {
                try {
                    this.con.rollback();
                    return this.doExecute(key);
                }
                catch (SQLException ex2) {
                    throw new RuntimeException("system error");
                }
            }
            throw new RuntimeException("connection lost");
        }
    }

    private void doReconnect() throws ThreadTerminateException {
        try {
            ++this.reconnectNumber;
            this.getClass();
            Thread.sleep(3000L);
            this.con = this.dataSource.getConnection();
            this.stmt = this.con.createStatement();
        }
        catch (SQLException ex) {
            String sqlState = ex.getSQLState();
            if (sqlState.equals("08S01") && this.reconnectNumber < this.reconnectLimitNumber) {
                this.doReconnect();
            }
            throw new ThreadTerminateException();
        }
        catch (Exception ex) {
            throw new RuntimeException("system error");
        }
    }
}

