/*
 * Decompiled with CFR 0.152.
 */
package jp.co.scs.mbench.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import jp.co.scs.mbench.DocumentUtil;
import jp.co.scs.mbench.jdbc.DataSourceImpl;
import jp.co.scs.mbench.jdbc.DataSourceInfo;

public class DataSourceImpl
implements DataSource {
    private int loginTimeout = 0;
    private PrintWriter logWriter = null;
    private String dataSourceName = null;
    private DataSourceInfo info = null;
    private String url = null;

    public DataSourceImpl(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.info.getUser(), this.info.getPassword());
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.loginTimeout == 0) {
            return DriverManager.getConnection(this.url, username, password);
        }
        Connection con = null;
        class InnerClass
        extends Thread {
            private boolean isTimeout;
            private Connection con;
            private String url;
            final /* synthetic */ DataSourceImpl this$0;
            private final /* synthetic */ String val$username;
            private final /* synthetic */ String val$password;

            public InnerClass(DataSourceImpl dataSourceImpl, Connection con, String url, String string, String string2) {
                this.this$0 = dataSourceImpl;
                this.val$username = string;
                this.val$password = string2;
                this.isTimeout = false;
                this.con = null;
                this.url = null;
                this.con = con;
                this.url = url;
            }

            public void setIsTimeout(boolean isTimeout) {
                this.isTimeout = isTimeout;
            }

            public void run() {
                try {
                    this.con = DriverManager.getConnection(this.url, this.val$username, this.val$password);
                    if (this.isTimeout) {
                        this.con.close();
                    }
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        InnerClass innerClass = new InnerClass(this, con, this.url, username, password);
        innerClass.start();
        try {
            innerClass.join(this.loginTimeout * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (con == null) {
            innerClass.setIsTimeout(true);
            throw new SQLException("timeout : " + this.loginTimeout + " sec");
        }
        return con;
    }

    public void initialize() {
        try {
            this.info = DocumentUtil.getDataSourceInfo(this.dataSourceName);
            Class.forName(this.info.getDriver());
            if (this.info.getProtocol() == null) {
                throw new IllegalArgumentException("protocol is null");
            }
            if (this.info.getDriver() == null) {
                throw new IllegalArgumentException("JDBC Driver name is null");
            }
            if (this.info.getHost() == null) {
                throw new IllegalArgumentException("host is null");
            }
            if (this.info.getDB() == null) {
                throw new IllegalArgumentException("database instance name is null");
            }
            if (!this.info.getPort().equals("")) {
                this.info.setPort(":" + this.info.getPort());
            }
            this.url = "jdbc:" + this.info.getProtocol() + "://" + this.info.getHost() + this.info.getPort() + "/" + this.info.getDB();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("JDBC Driver name or CLASSPATH is wrong");
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("exception caused by getting DataSourceInfo named :" + this.dataSourceName + " , dataSource setting might be wrong");
        }
    }
}

