/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Interface of benchmark components.<br>
 *      <br>
 *      "setBenchmarkName" method should be called when an instance
 *      of it's implementation class is created. 
 * 
 *      @author Tetsuro Ikeda
 *      @author Masato Koga
 */
public interface Benchmark {
    /**
     *  gets the benchmark component name.
     * 
     *  @return component name
     */
    String getBenchmarkName();
    
    /**
     *  sets the benchmark component name.
     * 
     *  @param benchmarkName component name
     */
    void setBenchmarkName(String benchmarkName);
    
    /**
     *  returns the labels of items for the benchmark component.
     * 
     *  @return labels 
     */
    String[] getOptionLabels();
    
    /**
     *  returns the labels of items for the benchmark component.
     * 
     *  @param optionLabels labels
     */
    void setOptionLabels(String[] optionLabels);
    
    /**
     *  initializes the benchmark component
     */
    void init() throws BenchmarkTerminateException;
    
    /**
     *  executes the benchmark
     * 
     *  @return results of each execution of benchmark
     */
    String[] execute()
            throws ThreadTerminateException, BenchmarkTerminateException;
    
    /**
     *  finalizes the benchmark component
     */
    void clean() throws BenchmarkAbortException;
}
