/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Runtime Exception to abort the benchmark
 * 
 *      @author Tetsuro Ikeda
 */
public class BenchmarkAbortException extends RuntimeException {
    /**
     *  Creates the instance of this class.
     */
    public BenchmarkAbortException() {
        super();
    }

    /**
     *  Creates the instance of this class with an exception message.
     *
     *  @param message exception message
     */
    public BenchmarkAbortException(String message) {
        super(message);
    }

    /**
     *  Creates the instance of this class with an exception message
     *  and a nested exception instance.
     *
     *  @param message exception message
     *  @param cause nested exception
     */
    public BenchmarkAbortException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     *  Creates the instance of this class with a nested exception instance.
     *
     *  @param cause nested exception
     */
    public BenchmarkAbortException(Throwable cause) {
        super(cause);
    }
}
