/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Exception class for terminating the benchmark
 * 
 *      @author Masato Koga
 */
public class BenchmarkTerminateException extends Exception {
    /**
     *  Creates the instance of this class
     */
    public BenchmarkTerminateException() {
        super();
    }

    /**
     *  Creates the instance of this class with error message.
     *
     *  @param message error message
     */
    public BenchmarkTerminateException(String message) {
        super(message);
    }

    /**
     *  Creates the instance of this class with error message and nested exception.
     *
     *  @param message error message
     *  @param cause nested exception
     */
    public BenchmarkTerminateException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     *  Creates the instance of this class with nested exception
     *
     *  @param cause nested exception
     */
    public BenchmarkTerminateException(Throwable cause) {
        super(cause);
    }
}
