/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Interface of data log handler
 * 
 *      @author Tetsuro Ikeda
 */
public interface DataWriter {
    /**
     *  Gets the data name
     * 
     *  @return data name
     */
    String getDataName();
    
    /**
     *  Sets the data name
     *  
     *  @param dataName data name
     */
    void setDataName(String dataName);
    
    /**
     *  Initializes the data log handler (data writer)
     * 
     *  @throws BenchmarkTerminateException benchmark should be terminated
     */
    void init() throws BenchmarkTerminateException;
    
    /**
     *  writes the data log
     * 
     *  @param data data
     */
    void write(String[] data);
    
    /**
     *  Finalizes the date log handler (data writer)
     */
    void clean();
}
