/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Main method class for finalization
 * 
 *      @author Tetsuro Ikeda
 */
public class FinalizeMain {
    private static FinalizeManager manager = null;
    
    public static void main(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            String finalizerName = args[0];
            if (manager == null) {
                manager = new FinalizeManager(finalizerName);
            }
            
            manager.execute();
        } else {
            printUsage();
        }
    }
    
    /**
     *  Gets the FinalizeManager.
     *  
     *  @return FinalizeManager
     */
    public static FinalizeManager getManager() {
        return manager;
    }
    
    /**
     *  Sets the FinalizeManager.
     * 
     *  @param manager FinalizeManager
     */
    public static void setManager(FinalizeManager manager) {
        FinalizeMain.manager = manager;
    }
    
    /**
     *  Gets the usage message.
     */
    public static String getUsage() {
        return MessageResources.getMessage("FinalizeMain.usage");
    }
    
    /**
     *  Prints usage message.
     */
    private static void printUsage() {
        System.out.print(getUsage());
    }
}
