/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/**
 *      The finalize manager class
 * 
 *      @author Tetsuro Ikeda
 */
public class FinalizeManager {
    /**
     *  finalizer name
     */
    private String finalizerName = null;
    
    /**
     *  finalizer
     */
    private Finalizer finalizer = null;
    
    /**
     *  Creates a finalize manager instance with finalizer name.
     * 
     *  @param finalizerName finalizer name
     */
    public FinalizeManager(String finalizerName) {
        this.finalizerName = finalizerName;
    }
    
    /**
     *  Gets the finalizer name.
     * 
     *  @return finalizer name
     */
    public String getFinalizerName() {
        return this.finalizerName;
    }
    
    /**
     *  Sets the finalizer name.
     * 
     *  @param finalizerName finalizer name
     */
    public void setFinalizerName(String finalizerName) {
        this.finalizerName = finalizerName;
    }

    /**
     *  Gets the finalizer.
     *
     *  @return finalizer
     */
    public Finalizer getFinalizer() {
        return this.finalizer;
    }
    
    /**
     *  Sets the finalizer.
     * 
     *  @param finalizer finalizer
     */
    public void setFinalizer(Finalizer finalizer) {
        this.finalizer = finalizer;
    }
    
    /**
     *  executes the finalization.
     *  before calling thie method, finalizerName must be set by setter.
     * 
     *  @throws BenchmarkTerminateException benchmark should be terminated
     */
    public void execute() throws BenchmarkTerminateException {
        try {
            FinalizerInfo info = DocumentUtil.getFinalizerInfo(this.finalizerName);
            this.finalizer = getFinalizer(info);
            finalizer.setFinalizerName(this.finalizerName);
            finalizer.execute();
            System.out.println("finalize done ... " + finalizerName);
        
        } catch (BenchmarkAbortException ex) {
            throw new BenchmarkTerminateException(ex);
        } catch (IOException ex) {
            throw new BenchmarkTerminateException();
        } catch (ParserConfigurationException ex) {
            throw new BenchmarkTerminateException();
        } catch (SAXException ex) {
            throw new BenchmarkTerminateException();
        } 
    }
    
    /**
     *  Gets the finalizer instance from finalizer information.
     * 
     *  @param info finalizer information
     *  @return finalizer
     */
    public Finalizer getFinalizer(FinalizerInfo info) {
        try {
            Class classObject;
            classObject = Class.forName(info.getClassName());
            return (Finalizer) classObject.newInstance();
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new BenchmarkAbortException(
                "can't get the class : " + info.getClassName());
        } catch (InstantiationException ex) {
            ex.printStackTrace();
            throw new BenchmarkAbortException(
                "can't get the class : " + info.getClassName());
        } catch (IllegalAccessException ex) {
            ex.printStackTrace();
            throw new BenchmarkAbortException(
                "can't get the class : " + info.getClassName());
        }
    }
}
