/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Finalizer information class
 * 
 *      @author Tetsuro Ikeda
 */
public class FinalizerInfo {
    /**
     *  name of finalizer
     */
    private String name = null;
    
    /**
     *  type of finalizer
     */
    private String type = null;
    
    /**
     *  class name of finalizer
     */
    private String className = null;
    
    /**
     *  Gets the name of finalizer.
     * 
     *  @return name of finalizer
     */
    public String getName() {
        return this.name;
    }
    
    /**
     *  Sets the name of finalizer.
     * 
     *  @param name name of finalizer
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     *  Gets the type of finalizer.
     * 
     *   @return type of finalizer
     */
    public String getType() {
        return this.type;
    }
    
    /**
     *  Sets the type of finalizer.
     *
     *  @param type type of finalizer
     */
    public void setType(String type) {
        this.type = type;
    }
    
    /**
     *  Gets the class name of finalizer.
     * 
     *  @return class name of finalizer
     */
    public String getClassName() {
        return this.className;
    }
    
    /**
     *  Sets the class name of finalizer.
     * 
     *  @param className class name of finalizer
     */
    public void setClassName(String className) {
        this.className = className;
    }
}
