/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Main method class for Initialization
 * 
 *      @author Tetsuro Ikeda
 */
public class InitializeMain {
    /**
     *  InitilizeManager
     */
    private static InitializeManager manager = null;
    
    public static void main(String[] args) throws Exception{
        if (args != null && args.length > 0) {
            String initializerName = args[0];
            if (manager == null) {
                manager = new InitializeManager(
                        initializerName);
            }
            manager.execute();
        } else {
            printUsage();
        }
    }
    
    /**
     *  Set the InitilizeManager.
     *  
     *  @return InitilizeManager
     */
    public static InitializeManager getManager() {
        return manager;
    }
    
    /**
     *  Set the InitilizeManager.
     * 
     *  @param manager InitilizeManager
     */
    public static void setManager(InitializeManager manager) {
        InitializeMain.manager = manager;
    }
    
    /**
     *  Gets the usage message
     */
    public static String getUsage() {
        return MessageResources.getMessage("InitializeMain.usage");
    }
    
    /**
     *  Prints the usage message
     */
    private static void printUsage() {
        System.out.print(getUsage());
    }
}
