/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;

import org.xml.sax.SAXException;

/**
 *      The initialize manager class
 * 
 *      @author Tetsuro Ikeda
 */
public class InitializeManager {
    /**
     *  initializer name
     */
    private String initializerName = null;
    
    /**
     *  initializer
     */
    private Initializer initializer = null;
    
    /**
     *  Creates a initialize manager instance with initializer name.
     * 
     *  @param initializerName initializer name
     */
    public InitializeManager(String initializerName) {
        this.initializerName = initializerName;
    }
    
    /**
     *  Gets the initializer name.
     * 
     *  @return initializer name
     */
    public String getInitializerName() {
        return this.initializerName;
    }
    
    /**
     *  Sets the initializer name.
     * 
     *  @param initializerName initializer name
     */
    public void setInitializerName(String initializerName) {
        this.initializerName = initializerName;
    }
    
    /**
     *  Gets the initializer.
     *
     *  @return initializer
     */
    public Initializer getInitializer() {
        return this.initializer;
    }

    /**
     *  Sets the initializer.
     * 
     *  @param initializer initializer
     */
    public void setInitializer(Initializer initializer) {
        this.initializer = initializer;
    }
    
    /**
     *  Executes the initialization.
     *  Before calling thie method, initializer name must be set.
     * 
     *  @throws BenchmarkTerminateException benchmark should be terminated
     */
    public void execute() throws BenchmarkTerminateException {
        try {
            InitializerInfo info = DocumentUtil.getInitializerInfo(this.initializerName);
            this.initializer = getInitializer(info);
            initializer.setInitializerName(info.getName());
            initializer.execute();
            System.out.println("initialize done ... " + initializerName);
        } catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(
                    "error occur in InitializerManager#execute");
        } catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            throw new RuntimeException(
                    "error occur in InitializerManager#execute");
        } catch (SAXException ex) {
            ex.printStackTrace();
            throw new RuntimeException(
                    "error occur in InitializerManager#execute");
        }
    }
    
    /**
     *  Gets the initializer instance from finalizer information.
     * 
     *  @param info initializer information
     *  @return initializer
     */
    public Initializer getInitializer(InitializerInfo info) {
        try {
            Class classObject;
            classObject = Class.forName(info.getClassName());
            return (Initializer) classObject.newInstance();
        } catch (ClassNotFoundException ex) {
            throw new BenchmarkAbortException(ex);
        } catch (InstantiationException ex) {
            throw new BenchmarkAbortException(ex);
        } catch (IllegalAccessException ex) {
            throw new BenchmarkAbortException(ex);
        }
    }
}
