/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Initializer information class
 * 
 *      @author Tetsuro Ikeda
 */
public class InitializerInfo {
    /**
     *  name of initializer
     */
    private String name = null;
    
    /**
     *  type of initializer
     */
    private String type = null;
    
    /**
     *  class name of initializer
     */
    private String className = null;
    
    /**
     *  Gets the name of initializer.
     * 
     *  @return name of initializer
     */
    public String getName() {
        return this.name;
    }
    
    /**
     *  Sets the name of initializer.
     * 
     *  @param name name of initializer
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     *  Gets the type of initializer.
     * 
     *   @return type of initializer
     */
    public String getType() {
        return this.type;
    }
    
    /**
     *  Sets the type of initializer.
     *
     *  @param type type of initializer
     */
    public void setType(String type) {
        this.type = type;
    }
    
    /**
     *  Gets the class name of initializer.
     * 
     *  @return class name of initializer
     */
    public String getClassName() {
        return this.className;
    }
    
    /**
     *  Sets the class name of initializer.
     * 
     *  @param className class name of initializer
     */
    public void setClassName(String className) {
        this.className = className;
    }
}
