/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

import java.util.Date;

/**
 *      System log holder
 * 
 *      @author Tetsuro Ikeda
 */
public class LogHolder {
    /**
     *  time of log
     */
    private Date date = null;
    
    /**
     *  level of log
     */
    private int logLevel = LogWriter.INFO;
    
    /**
     *  matter of log
     */
    private String logDesc = null;

    /**
     *  Creates a log holder instance.
     */
    public LogHolder() {
    }

    /**
     *  Creates a log holder instance with date, log level and log matter.
     * 
     *  @param date time of log
     *  @param logLevel level of log
     *  @param logDesc matter of log
     */
    public LogHolder(Date date, int logLevel, String logDesc) {
        this.date = date;
        this.logLevel = logLevel;
        this.logDesc = logDesc;
    }
    
    /**
     *  Gets the time of log.
     * 
     *  @return time of log
     */
    public Date getDate() {
        return this.date;
    }
    
    /**
     *  Sets the time of log.
     * 
     *  @param date time of log
     */
    public void setDate(Date date) {
        this.date = date;
    }
    
    /**
     *  Gets the level of log.
     * 
     *  @return level of log
     */
    public int getLogLevel() {
        return this.logLevel;
    }
    
    /**
     *  Sets the level of log.
     * 
     *  @param logLevel level of log
     */
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }
    
    /**
     *  Gets the matter of log.
     *  
     *  @return matter of log
     */
    public String getLogDesc() {
        return this.logDesc;
    }
    
    /**
     *  Sets the matter of log.
     * 
     *  @param logDesc matter of log
     */
    public void setLogDesc(String logDesc) {
        this.logDesc = logDesc;
    }
}
