/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench;

/**
 *      Multiple node information
 * 
 *      @author Tetsuro Ikeda
 */
public class MultiNodeInfo {
    /**
     *  name of local host
     */
    public static final String defaultLocalHost = "localhost";
    
    /**
     *  number of local port
     */
    public static final int defaultPort = 2826; // "We oppose the software patent"
    
    /**
     *  statement of single node
     */
    public static final String NODE_SINGLE = "single";
    
    /**
     *  statement of primary node on multiple nodes
     */
    public static final String NODE_PRIMARY = "primary";
    
    /**
     *  statement of secondary node on multiple nodes
     */
    public static final String NODE_SECONDARY = "secondary";
    
    /**
     *  Name of multipule nodes
     */
    private String name = null;
    
    /**
     *  Type of node
     */
    private String nodeType = null;
    
    /**
     *  Name of localhost or IP address
     */
    private String localHost = defaultLocalHost;
    
    /**
     *  Number of port 
     */
    private int localPort = defaultPort;
    
    /**
     *  Names of secondary node's host.
     *  Used if the node type is primary.
     */
    private String[] secondaryHost = null;
    
    /**
     *  Numbers of secondary node's port
     */
    private int[] secondaryPort = null;
    
    /**
     *  Gets the name of local host.
     *  Default is "localhost".
     * 
     *  @return name of local host
     */
    public String getLocalHost() {
        return this.localHost;
    }
    
    /**
     *  Sets the name of local host.
     * 
     *  @param localHost name of local host
     */
    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }
    
    /**
     *  Gets the number of local port.
     *  Default is "2826".
     * 
     *  @return number of local port
     */
    public int getLocalPort() {
        return this.localPort;
    }
    
    /**
     *  Sets the number of local port.
     * 
     *  @param localPort number of local port
     */
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }
    
    /**
     *  Gets the name of multipule nodes.
     * 
     *  @return name of multipule nodes
     */
    public String getName() {
        return this.name;
    }
    
    /**
     *  Sets the name of multipule nodes.
     * 
     *  @param name name of multipule nodes
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     *  Sets the type of node.
     * 
     *  @return Type of nodes
     */
    public String getNodeType() {
        return this.nodeType;
    }
    
    /**
     *  Gets the type of node.
     * 
     *  @param nodeType Type of node
     */
    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }
    
    /**
     *  Gets the names of secondary node's host.
     *  Used if the node type is primary.
     *  Since two or more secondary nodes may exist,
     *  they are using arrangement.
     * 
     *  @return names of secondary node's host
     */
    public String[] getSecondaryHost() {
        return this.secondaryHost;
    }
    
    /**
     *  Sets the names of secondary node's host.
     *  Used if the node type is primary.
     *  Since two or more secondary nodes may exist,
     *  they are using arrangement.
     * 
     *  @param secondaryHost names of secondary node's host
     */
    public void setSecondaryHost(String[] secondaryHost) {
        this.secondaryHost = secondaryHost;
    }
    
    /**
     *  Gets the numbers of secondary node's port.
     *  Used if the node type is primary.
     *  Since two or more secondary nodes may exist,
     *  they are using arrangement.
     * 
     *  @return Numbers of secondary node's port
     */
    public int[] getSecondaryPort() {
        return this.secondaryPort;
    }
    
    /**
     *  Sets the numbers of secondary node's port.
     *  Used if the node type is primary.
     *  Since two or more secondary nodes may exist,
     *  they are using arrangement.
     * 
     *  @param secondaryPort Numbers of secondary node's port
     */
    public void setSecondaryPort(int[] secondaryPort) {
        this.secondaryPort = secondaryPort;
    }
}
