/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench.component;

import java.sql.Connection;
import java.sql.Statement;

import javax.sql.DataSource;

import jp.co.scs.mbench.Finalizer;
import jp.co.scs.mbench.jdbc.DataSourceManager;

/**
 *     Finalizer for drop table t1.
 * 
 *     @author Masato Koga
 */
public class T1Finalizer implements Finalizer {

    private String finalizerName = null;

    public String getFinalizerName() {
        return this.finalizerName;
    }
    
    public void setFinalizerName(String finalizerName) {
        this.finalizerName = finalizerName;
    }
    
    public void execute() {
        Connection con = null;
        Statement stmt = null;
        try {
            DataSource dataSource = DataSourceManager.getDataSource("mysql_con1");
            con = dataSource.getConnection();
            stmt = con.createStatement();
            String ddl1 = "drop table if exists t1";
            stmt.executeUpdate(ddl1);
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

}
