/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench.jdbc;

/**
 *      DataSource Information class
 * 
 *      @author Tetsuro Ikeda
 */
public class DataSourceInfo {
    /**
     *  definition name of DataSource
     */
    private String name = null;
    
    /**
     *  JDBC sub protocol name.
     *  For example, "mysql" is sub protocol for MySQL.
     */
    private String protocol = null;
    
    /**
     *  FQCN of Driver implementation class
     */
    private String driver = null;
    
    private String host = null;
    
    private String port = "";
    
    private String db = null;
    
    private String user = "";
    
    private String password = "";
    
    private String useUnicode = "true";
    
    private String characterEncoding = "";
    
    public String getDB() {
        return this.db;
    }
    
    public void setDB(String db) {
        this.db = db;
    }
    
    /**
     *  Gets the FQCN of Driver implementation class
     * 
     *  @return FQCN of Driver implementation class
     */
    public String getDriver() {
        return this.driver;
    }
    
    /**
     *  Sets the FQCN of Driver implementation class
     * 
     *  @param driver FQCN of Driver implementation class
     */
    public void setDriver(String driver) {
        this.driver = driver;
    }
    
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    /**
     *  Gets the definition name of DataSource
     *  
     *  @return definition name of DataSource
     */
    public String getName() {
        return this.name;
    }

    /**
     *  Sets the definition name of DataSource
     * 
     *  @param name definition name of DataSource
     */
    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }
    
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getUseUnicode() {
        return this.useUnicode;
    }

    public void setUseUnicode(String useUnicode) {
        this.useUnicode = useUnicode;
    }

    /**
     *  Gets the JDBC sub protocol name.
     *  For example, "mysql" is sub protocol for MySQL.
     *  
     *  @return JDBC sub protocol name
     */
    public String getProtocol() {
        return this.protocol;
    }

    /**
     *  Sets the JDBC sub protocol name.
     *  For example, "mysql" is sub protocol for MySQL.
     *  
     *  @param protocol JDBC sub protocol name
     */
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}
