/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package jp.co.scs.mbench.jdbc;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

/**
 *      DataSource Manager
 * 
 *      @author Tetsuro Ikeda
 */
public class DataSourceManager {
    
    private static Map dataSourceMap = new HashMap();
    
    /**
     *  Gets the dataSource by dataSourceName
     */
    public static synchronized DataSource getDataSource(String dataSourceName) {
        DataSourceImpl dataSourceImpl =
            (DataSourceImpl) dataSourceMap.get(dataSourceName);
        if (dataSourceImpl != null) {
            return dataSourceImpl;
        }
        dataSourceImpl = new DataSourceImpl(dataSourceName);
        dataSourceImpl.initialize();
        dataSourceMap.put(dataSourceName, dataSourceImpl);
        return (DataSource) dataSourceImpl;
    }
}
