/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench;

import test.jp.co.scs.mbench.jdbc.DataSourceImplTest;
import test.jp.co.scs.mbench.jdbc.DataSourceManagerTest;
import junit.framework.Test;
import junit.framework.TestSuite;

/**
 *      @author Masato Koga
 */
public class AllTests extends TestSuite {

    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    public static Test suite() {
        TestSuite suite = new AllTests();
        
        suite.addTestSuite(BenchmarkContainerTest.class);
        suite.addTestSuite(BenchmarkMainTest.class);
        suite.addTestSuite(BenchmarkManagerTest.class);
        suite.addTestSuite(CSVAsynchronousDataWriterTest.class);
        suite.addTestSuite(DocumentUtilTest.class);
        suite.addTestSuite(FinalizeMainTest.class);
        suite.addTestSuite(FinalizeManagerTest.class);
        suite.addTestSuite(InitializeMainTest.class);
        suite.addTestSuite(InitializeManagerTest.class);
        suite.addTestSuite(LogWriterTest.class);
        suite.addTestSuite(SynchronizerTest.class);
        suite.addTestSuite(DataSourceImplTest.class);
        suite.addTestSuite(DataSourceManagerTest.class);
        
        return suite;
    }
}
