/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Map;

import jp.co.scs.mbench.BenchmarkMain;
import jp.co.scs.mbench.BenchmarkState;
import junit.framework.TestCase;
import test.jp.co.scs.mbench.stub.StubBenchmarkMainBM;

/**
 *      @author Masato Koga
 */
public class BenchmarkMainTest extends TestCase {
    /**
     *  The test with options "-r" "-t" "-T" "-e". 
     */
    public void testMain1() {
        try {
            String[] args = {"-r10", "-t20", "-T150", "-e100", "test-benchmark"};
            StubBenchmarkMainBM manager = new StubBenchmarkMainBM(
                    "test-benchmark");
            BenchmarkMain.setManager(manager);
            BenchmarkMain.main(args);
            Map optionMap = manager.getOptionMap();
            manager.join();
            
            assertEquals(BenchmarkState.BENCHMARK_SUCCESS,
                    manager.getCurrentState());
            assertEquals(4, optionMap.size());
            assertEquals("10", ((String) optionMap.get(
                    BenchmarkMain.REPEAT_NUMBER)));
            assertEquals("20", ((String) optionMap.get(
                    BenchmarkMain.THREAD_NUMBER)));
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  The test with options "--threadNumber" "--repeatNumber" "--multi-client"
     */
    public void testMain2() {
        try {
            String[] args = {"--repeatNumber=10", "--threadNumber=20",
                    "--transactionNumber=150", "--benchmarkEndTime=100",
                    "--multi-client=multiNode", "test-benchmark"};
            StubBenchmarkMainBM manager = new StubBenchmarkMainBM(
                    "test-benchmark");
            BenchmarkMain.setManager(manager);
            BenchmarkMain.main(args);
            Map optionMap = manager.getOptionMap();
            manager.join();
            
            assertEquals(BenchmarkState.BENCHMARK_SUCCESS,
                    manager.getCurrentState());
            assertEquals(5, optionMap.size());
            assertEquals("10", ((String) optionMap.get(
                    BenchmarkMain.REPEAT_NUMBER)));
            assertEquals("20", ((String) optionMap.get(
                    BenchmarkMain.THREAD_NUMBER)));
            assertEquals("150", ((String) optionMap.get(
                    BenchmarkMain.TX_NUMBER)));
            assertEquals("100", ((String) optionMap.get(
                    BenchmarkMain.END_TIME)));
            assertEquals("multiNode", ((String) optionMap.get(
                    BenchmarkMain.MULTI_CLIENT)));
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  optionMap isn't overridden if options isn't used.
     */
    public void testMain3() {
        try {
            String[] args = {"test-benchmark"};
            StubBenchmarkMainBM manager = new StubBenchmarkMainBM(
                    "test-benchmark");
            BenchmarkMain.setManager(manager);
            BenchmarkMain.main(args);
            manager.join();
            
            assertEquals(BenchmarkState.BENCHMARK_SUCCESS,
                    manager.getCurrentState());
            assertNull(manager.getOptionMap());
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  Usage must be printed out if benchmark name wasn't specified.
     */
    public void testMain4() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            System.setOut(new PrintStream(output));
            String[] args = {"--repeatNumber=10", "--threadNumber=20"};
            BenchmarkMain.main(args);
            
            assertEquals(BenchmarkMain.getUsage(), output.toString());
            
            output.flush();
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  Usage must be printed out if any argments were specified.
     */
    public void testMain5() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            System.setOut(new PrintStream(output));
            String[] args = { };
            BenchmarkMain.main(args);
            
            assertEquals(BenchmarkMain.getUsage(), output.toString());
            
            output.flush();
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  Usage must be printed out if wrong options
     */
    public void testMain6() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            System.setOut(new PrintStream(output));
            String[] args = {"-a10", "test-benchmark"};
            BenchmarkMain.main(args);
            
            assertEquals(BenchmarkMain.getUsage(), output.toString());
            
            output.flush();
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
}
