/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import test.jp.co.scs.mbench.stub.StubFinalizeMainFM;
import jp.co.scs.mbench.FinalizeMain;
import jp.co.scs.mbench.BenchmarkState;
import junit.framework.TestCase;

/**
 *      @author Masato Koga
 */
public class FinalizeMainTest extends TestCase {
    /**
     *  The finialization must be done if command line argments
     *  include correct FQCN of finalizer and options.
     */
    public void testMain() {
        try {
            String[] args = {"test-finalize"};
            StubFinalizeMainFM manager = new StubFinalizeMainFM(
                    "test-finalize");
            FinalizeMain.setManager(manager);
            FinalizeMain.main(args);
            
            assertEquals(BenchmarkState.BENCHMARK_TERMINATED,
                    manager.getCurrentState());
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  Usage message must be printed out if command line argments
     *  doesn't include the FQCN of finalizer.
     */
    public void testMain2() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            System.setOut(new PrintStream(output));
            String[] args = { };
            FinalizeMain.main(args);
            
            assertEquals(FinalizeMain.getUsage(), output.toString());
            
            output.flush();
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
}
