/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench;

import jp.co.scs.mbench.BenchmarkAbortException;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.FinalizeManager;
import jp.co.scs.mbench.Finalizer;
import jp.co.scs.mbench.FinalizerInfo;
import junit.framework.TestCase;
import test.jp.co.scs.mbench.stub.StubFinalizeManager01;

/**
 *      @author Tetsuro Ikeda
 */
public class FinalizeManagerTest extends TestCase {

    private static final String FINALIZER_NAME1 = "StubFinalizeManager01";
    
    private static final String FINALIZER_NAME2 = "StubFinalizeManager02";
    
    private static final String FINALIZER_CLASS_NAME =
        "test.jp.co.scs.mbench.stub.StubFinalizeManager01";
    
    private static final String FINALIZER_WRONG_CLASS_NAME =
        "test.jp.co.scs.mbench.stub.hoge";
    
    private static final String CONFIGURATION_FILE_NAME = "conf/mbench.xml";

    private static final String TEST_CONFIGURATION_FILE_NAME1 = 
        "data/FinalizeManager/executeTest01/mbench.xml";

    private static final String TEST_CONFIGURATION_FILE_NAME2 = 
        "data/FinalizeManager/executeTest02/mbench.xml";

    private static final String DEFAULT_DIR = "conf";

    private static final String TEMP_DIR = "temp";
    
    /**
     *  Get the finalizer instance speficied by finalizer information.
     */
    public void testGetFinalizer() {
        try {
            FinalizerInfo finalizerInfo = new FinalizerInfo();
            finalizerInfo.setClassName(FINALIZER_CLASS_NAME);
            FinalizeManager finalizeManager =
                new FinalizeManager(FINALIZER_NAME1);
            Finalizer finalizer = 
                finalizeManager.getFinalizer(finalizerInfo);
            
            assertEquals(FINALIZER_CLASS_NAME, finalizer.getClass().getName());
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  BenchmarkAbortException must be thrown if the finalizer instance
     *  couldn't be get by finalizer information.
     */
    public void testGetFilanlizer2() {
        try {
            FinalizerInfo finalizerInfo = new FinalizerInfo();
            finalizerInfo.setClassName(FINALIZER_WRONG_CLASS_NAME);
            FinalizeManager finalizeManager =
                new FinalizeManager(FINALIZER_NAME1);
            finalizeManager.getFinalizer(finalizerInfo);
            fail();
        } catch (BenchmarkAbortException ex) {
            assertTrue(BenchmarkAbortException.class.
                    isAssignableFrom(ex.getClass())); 
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  Execute the finanlizer.
     */
    public void testExecute() {
        try {
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME1, DEFAULT_DIR);
            FinalizeManager finalizeManager =
                new FinalizeManager(FINALIZER_NAME1);
            finalizeManager.execute();
            Finalizer finalizer = 
                finalizeManager.getFinalizer();
    
            assertTrue(((StubFinalizeManager01)finalizer).isExecuteFlg());
        } catch (BenchmarkAbortException ex) {
            fail(ex.getMessage());
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        }
    }
    
    /**
     *  BenchmarkTerminateException must be thrown if finalizer failed.
     */
    public void testExecute2() {
        try {   
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME2, DEFAULT_DIR);
            FinalizeManager finalizeManager =
                new FinalizeManager(FINALIZER_NAME2);
            finalizeManager.execute();
            finalizeManager.getFinalizer();
            fail();
        } catch (BenchmarkTerminateException ex) {
            assertTrue(BenchmarkTerminateException.class.
                    isAssignableFrom(ex.getClass()));
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        }
    }
}
