/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import jp.co.scs.mbench.InitializeMain;
import jp.co.scs.mbench.BenchmarkState;
import junit.framework.TestCase;
import test.jp.co.scs.mbench.stub.StubInitializeMainIM;

/**
 *      @author Masato Koga
 */
public class InitializeMainTest extends TestCase {
    /**
     *  The initialization must be done if command line argments
     *  include correct FQCN of finalizer and options.
     */
    public void testMain() {
        try {
            String[] args = {"test-initialize"};
            StubInitializeMainIM manager = new StubInitializeMainIM(
                    "test-initialize");
            InitializeMain.setManager(manager);
            InitializeMain.main(args);
            
            assertEquals(BenchmarkState.BENCHMARK_TERMINATED,
                    manager.getCurrentState());
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
    
    /**
     *  Usage message must be printed out if command line argments
     *  doesn't include the FQCN of initializer.
     */
    public void testMain2() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            System.setOut(new PrintStream(output));
            
            String[] args = { };
            InitializeMain.main(args);
            
            assertEquals(InitializeMain.getUsage(), output.toString());
            
            output.flush();
        } catch (Exception ex) {
            fail(ex.getMessage());
        }
    }
}
