/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.jdbc;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;

import jp.co.scs.mbench.jdbc.DataSourceImpl;
import junit.framework.TestCase;
import test.jp.co.scs.mbench.FileUtil;
import test.jp.co.scs.mbench.stub.StubDataSourceImpl02;
import test.jp.co.scs.mbench.stub.StubDataSourceImpl03;

/**
 *      @author Tetsuro Ikeda
 */
public class DataSourceImplTest extends TestCase {

    private static final String DRIVER_NAME =
        "test.jp.co.scs.mbench.stub.StubDataSourceImpl01";
    
    private static final String DATA_SOURCE_NAME = "a4";
    
    private static final String CONFIGURATION_FILE_NAME = "conf/mbench.xml";
    
    private static final String TEST_CONFIGURATION_FILE_NAME1 = 
        "data/DataSourceImpl/executeTest01/mbench.xml";
    
    private static final String TEST_CONFIGURATION_FILE_NAME2 = 
        "data/DataSourceImpl/executeTest02/mbench.xml";
    
    private static final String TEST_CONFIGURATION_FILE_NAME3 = 
        "data/DataSourceImpl/executeTest03/mbench.xml";
    
    private static final String DEFAULT_DIR = "conf";
    
    private static final String TEMP_DIR = "temp";
    
    private static final int SLEEP_TIME = 1;
    
    /**
     *  Initialize by the specified data source name.
     */
    public void testInitialize() {
        try {
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME1, DEFAULT_DIR);
            DataSourceImpl dataSourceImpl = new DataSourceImpl(DATA_SOURCE_NAME);
            dataSourceImpl.initialize();
            Enumeration enumeration = DriverManager.getDrivers();
            int count = 0;
            Object driverName = null;
            while (enumeration.hasMoreElements()) {
                driverName = enumeration.nextElement();
                count++;
            }

            assertEquals(1, count);
            assertEquals(DRIVER_NAME, driverName.getClass().getName());
        } catch (Exception ex) {
            ex.printStackTrace();
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        }
    }
    
    /**
     *  Get the connection object.
     */
    public void testGetConnection() {
        try {
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME2, DEFAULT_DIR);
            DataSourceImpl dataSourceImpl = new DataSourceImpl(DATA_SOURCE_NAME);
            dataSourceImpl.initialize();

            assertNotNull(dataSourceImpl.getConnection());
            assertEquals("hoge", StubDataSourceImpl02.getUser());
            assertEquals("foo", StubDataSourceImpl02.getPassword());
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        }
    }
    
    /**
     *  Get the connection object with username, password.
     */
    public void testGetConnectionStringString() {
        try {
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME2, DEFAULT_DIR);
            DataSourceImpl dataSourceImpl = new DataSourceImpl(DATA_SOURCE_NAME);
            dataSourceImpl.initialize();
            
            assertNotNull(dataSourceImpl.getConnection("test", "test"));
            assertEquals("test", StubDataSourceImpl02.getUser());
            assertEquals("test", StubDataSourceImpl02.getPassword());
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        }
    }
    
    /**
     *  Timeout test.
     */
    public void testGetConnectionStringString2() {
        try {
            FileUtil.copyFiles(CONFIGURATION_FILE_NAME, TEMP_DIR);
            FileUtil.deleteFile(CONFIGURATION_FILE_NAME);
            FileUtil.copyFiles(TEST_CONFIGURATION_FILE_NAME3, DEFAULT_DIR);
            DataSourceImpl dataSourceImpl = new DataSourceImpl(DATA_SOURCE_NAME);
            dataSourceImpl.setLoginTimeout(SLEEP_TIME);
            StubDataSourceImpl03.setSleepTime(SLEEP_TIME + 1);
            dataSourceImpl.initialize();
            dataSourceImpl.getConnection();
            fail();
        } catch (SQLException ex) {
            assertTrue(SQLException.class.isAssignableFrom(ex.getClass()));
        } catch (Exception ex) {
            fail(ex.getMessage());
        } finally {
            try {
                FileUtil.copyFiles(TEMP_DIR, DEFAULT_DIR);
            } catch (Exception ex) {
                fail(ex.getMessage());
            } finally {
                FileUtil.deleteFile(TEMP_DIR);
            }
        }
    }
}
