/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.stub;

import jp.co.scs.mbench.BenchmarkInfo;
import jp.co.scs.mbench.BenchmarkTerminateException;
import jp.co.scs.mbench.DataWriter;
import jp.co.scs.mbench.LogWriter;
import jp.co.scs.mbench.BenchmarkState;
import jp.co.scs.mbench.Synchronizer;

/**
 *      The stub for testing BenchmarkManager.
 *      This stub throws BenchmarkTerminateException at init method.
 * 
 *      @author Tetsuro Ikeda
 */
public class StubBenchmarkManagerContainer2 extends
        StubBenchmarkManagerContainer {

    private static int errorIndex = 0;
    
    private static int index = 0;
    
    public StubBenchmarkManagerContainer2(
            int containerID,
            BenchmarkInfo info,
            Synchronizer synchronizer,
            LogWriter logWriter,
            DataWriter dataWriter) {
        super(containerID, info, synchronizer, logWriter, dataWriter);
    }
    
    public static void setErrorIndex(int errorIndex) {
        StubBenchmarkManagerContainer2.errorIndex = errorIndex;
    }

    public void initTarget() throws BenchmarkTerminateException {
        this.currentState = BenchmarkState.INITIALIZING;
        if (++index >= errorIndex) {
            this.currentState = BenchmarkState.BENCHMARK_TERMINATED;
            throw new BenchmarkTerminateException();
        }
        this.currentState = BenchmarkState.INITIALIZED;
        this.isInitialized = true;
    }
}
