/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.stub;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;

/**
 *      The stub behave as primary node and notifies the error
 *      after the initialization.
 *
 *      @author Toshio Sugahara
 */
public class StubBenchmarkManagerMultiNode03
        extends Thread {

    protected Socket socket = null;

    private static final String TARGET_HOST = "localhost";

    private static final int TARGET_PORT = 5032;

    private static final int LOCAL_PORT = 5031;

    private static final String INIT_MESSAGE = "doInit";

    private static final String INIT_ERROR_MESSAGE = "ERROR:init";

    private static final String MANAGER_ID = "1";

    public Socket getSocket() {
        return this.socket;
    }

    public void run() {
        try {
            InetAddress localAddress = InetAddress.getByName(TARGET_HOST);
            this.socket = 
                new Socket(TARGET_HOST, TARGET_PORT, localAddress, LOCAL_PORT); 
            OutputStream os = this.socket.getOutputStream();
            String sendMessage = INIT_MESSAGE + MANAGER_ID;
            os.write(new String(sendMessage).getBytes());
            sleep(50);
            
            sendMessage = null;
            sendMessage = INIT_ERROR_MESSAGE;
            os.write(new String(sendMessage).getBytes());
        } catch (UnknownHostException ex) {
            ex.printStackTrace();
        } catch (IOException ex){
            ex.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}
