/*                          
 * mBench: The Open Source Micro Benchmark Tool 
 *                                             
 * Distributable under GPL license. 
 * See terms of license at gnu.org.                 
 *
 * Copyright (C) 2005 Sumisho Computer Systems Corp.
 */
package test.jp.co.scs.mbench.stub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

/**
 *      The stub behave as secondary.
 * 
 *      @author Tetsuro Ikeda
 */
public class StubBenchmarkManagerSecondaryNode5 extends
        StubBenchmarkManagerSecondaryNode {

    public StubBenchmarkManagerSecondaryNode5(int port) {
        super(port);
    }

    public void run() {
        try {
            ServerSocket server = new ServerSocket(this.port);
            server.setSoTimeout(50000);
            Socket socket = server.accept();
            socket.setSoTimeout(50000);
            byte[] buffer = new byte[20];
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            is.read(buffer);
            buffer = trimBlankByte(buffer);
            String message = new String(buffer);
            this.messageList.add(message);

            os.write(new String("doInit OK").getBytes());
            
            byte[] buffer2 = new byte[20];
            is.read(buffer2);
            buffer2 = trimBlankByte(buffer2);
            String message2 = new String(buffer2);
            this.messageList.add(message2);
            
            byte[] buffer3 = new byte[20];
            is.read(buffer3);
            buffer3 = trimBlankByte(buffer3);
            String message3 = new String(buffer3);
            this.messageList.add(message3);

            byte[] buffer4 = new byte[20];
            is.read(buffer4);
            buffer4 = trimBlankByte(buffer4);
            String message4 = new String(buffer4);
            this.messageList.add(message4);

        } catch (IOException ex) {
            this.messageList.add(ex.getMessage());
            ex.printStackTrace();
        }
    }
}