#include "crash.h"

extern const commandtable_t
	command_address_space,
	command_binfmt,
	command_bio,
	command_bio_vec,
	command_block_device,
	command_buffer_head,
	command_device,
	command_exception_table,
	command_ext2_inode_info,
	command_fib_table,
	command_file,
	command_file_lock,
	command_files_stat,
	command_gendisk,
	command_inode,
	command_kmem_cache,
	command_mempool,
	command_namespace,
	command_neighbour,
	command_nfs_inode,
	command_nfs_page,
	command_nfs_server,
	command_operations,
	command_page,
	command_pglist_data,
	command_request_queue,
	command_rtable,
	command_sighand_struct,
	command_signal_struct,
	command_slab,
	command_sock,
	command_socket,
	command_swap_info,
	command_timer_vec,
	command_tty_struct,
	command_usb_bus,
	command_usb_device,
	command_usb_driver,
	command_usb_interface,
	command_user_struct,
	command_vm_area_struct,
	command_vm_struct,
	command_wait_queue_head,
	command_zone;

const commandtable_t *commandtable_vers[] = {
	&command_address_space,
	&command_binfmt,
	&command_bio,
	&command_bio_vec,
	&command_block_device,
	&command_buffer_head,
	&command_device,
	&command_exception_table,
	&command_ext2_inode_info,
	&command_fib_table,
	&command_file,
	&command_file_lock,
	&command_files_stat,
	&command_gendisk,
	&command_inode,
	&command_kmem_cache,
	&command_mempool,
	&command_namespace,
	&command_neighbour,
#if defined(CONFIG_NFS_FS) || defined(CONFIG_NFS_FS_MODULE)
	&command_nfs_inode,
	&command_nfs_page,
	&command_nfs_server,
#endif
	&command_operations,
	&command_page,
	&command_pglist_data,
	&command_request_queue,
	&command_rtable,
	&command_sighand_struct,
	&command_signal_struct,
	&command_slab,
	&command_sock,
	&command_socket,
	&command_swap_info,
	&command_timer_vec,
	&command_tty_struct,
#if defined(CONFIG_USB) || defined(CONFIG_USB_MODULE)
	&command_usb_bus,
	&command_usb_device,
	&command_usb_driver,
	&command_usb_interface,
#endif
	&command_user_struct,
	&command_vm_area_struct,
	&command_vm_struct,
	&command_wait_queue_head,
	&command_zone,
};
const int ncmdtable_vers = LENGTHOF(commandtable_vers);

void
vers_init()
{
	extern addr_t cache_chain_addr;
	extern addr_t init_task_addr;

	cache_chain_addr = searchaddr_bysym("cache_chain");
	init_task_addr = searchaddr_bysym("init_task");
}
