/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t rtable();
const commandtable_t command_rtable =
	{"rtable", rtable, "[address]", "print rtable"};
extern void prhead_rtable();
extern addr_t print_rtable();
extern addr_t print_rt_hash_table();

PRIVATE addr_t fib_table();
const commandtable_t command_fib_table =
	{"fib_table", fib_table, "", "print fib_table"};
extern void prhead_fib_table();
extern addr_t print_fib_table();
addr_t ip_fib_main_table_addr, ip_fib_local_table_addr;

PRIVATE addr_t
rtable()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		static addr_t rt_hash_table_addr, rt_hash_mask_addr;
		addr_t rt_hash_table;
		unsigned rt_hash_mask;

		GETADDR(rt_hash_table);
		GETADDR(rt_hash_mask);
		memread(rt_hash_table_addr, sizeof(rt_hash_table), &rt_hash_table, "rt_hash_table");
		memread(rt_hash_mask_addr, sizeof(rt_hash_mask), &rt_hash_mask, "rt_hash_mask");
		print_rt_hash_table(rt_hash_table, rt_hash_mask + 1);
	} else {
		prhead_rtable();
		while (args[optind]) {
			addr = print_rtable(getvalue(args[optind]));
			optind++;
		}
	}
	return addr;
}

addr_t
fib_table()
{
	addr_t addr;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind != argcnt) {
		prhead_fib_table();
		print_fib_table(getvalue(args[optind]));
		return 0;
	}

	GETADDR(ip_fib_main_table);
	mprintf("ip_fib_main_table\n");
	memread(ip_fib_main_table_addr, sizeof(addr), &addr, "ip_fib_main_table");
	prhead_fib_table();
	print_fib_table(addr);

	GETADDR(ip_fib_local_table);
	mprintf("\nip_fib_local_table\n");
	memread(ip_fib_local_table_addr, sizeof(addr), &addr, "ip_fib_local_table");
	prhead_fib_table();
	print_fib_table(addr);

	return 0;
}
