/*
 * Copyright (C) 2005 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/types.h>
#include <linux/jbd.h>

void
prhead_handle()
{
	mprintf(SPTR" "SPTR" BUF_CR REF ERR FLAGS\n", "ADDR", "TRANS");
}

addr_t
print_handle(addr, full)
	addr_t addr;
	int full;
{
#if defined(CONFIG_JBD) || defined(CONFIG_JBD_MODULE)

	handle_t handle;

	memread(addr, sizeof(handle), &handle, "handle_t");
	mprintf(FPTR " ", addr);

	mprintf(FPTR " %6x %3x %3x%s%s%s\n", handle.h_transaction,
		handle.h_buffer_credits, handle.h_ref, handle.h_err,
		handle.h_sync? " sync": "",
		handle.h_jdata? " jdata": "",
		handle.h_aborted? " aborted": "");
	return (addr_t)0;

#endif /*CONFIG_JBD*/
}

void
prhead_journal()
{
}

addr_t
print_journal(addr, full)
	addr_t addr;
	int full;
{
#if defined(CONFIG_JBD) || defined(CONFIG_JBD_MODULE)

	journal_t journal;
	int i;

	memread(addr, sizeof(journal), &journal, "journal_t");
	mprintf(FPTR "\n", addr);

	mprintf("flags:                   %lx\n", journal.j_flags);
	mprintf("errno:                   %x\n", journal.j_errno);
	mprintf("sb_buffer:               " FPTR "\n", journal.j_sb_buffer);
	mprintf("superblock:              " FPTR "\n", journal.j_superblock);
	mprintf("format_version:          %x\n", journal.j_format_version);
	mprintf("barrier_count:           %x\n", journal.j_barrier_count);
	mprintf("running_transaction:     " FPTR "\n", journal.j_running_transaction);
	mprintf("committing_transaction:  " FPTR "\n", journal.j_committing_transaction);
	mprintf("checkpoint_transactions: " FPTR "\n", journal.j_checkpoint_transactions);
	mprintf("head/tail:               %lx / %lx\n", journal.j_head, journal.j_tail);
	mprintf("free:                    %lx\n", journal.j_free);
	mprintf("first/last:              %lx / %lx\n", journal.j_first, journal.j_last);
	mprintf("dev:                     (");
	mprint_kdev_t(journal.j_dev);
	mprintf(")\n");
	mprintf("blocksize:               %x\n", journal.j_blocksize);
	mprintf("blk_offset:              %x\n", journal.j_blk_offset);
	mprintf("fs_dev:                  (");
	mprint_kdev_t(journal.j_dev);
	mprintf(")\n");
	mprintf("maxlen:                  %x\n", journal.j_maxlen);
	mprintf("inode:                   " FPTR "\n", journal.j_inode);
	mprintf("tail_sequence:           %lx\n", journal.j_tail_sequence);
	mprintf("transaction_sequence:    %lx\n", journal.j_transaction_sequence);
	mprintf("commit_sequence:         %lx\n", journal.j_commit_sequence);
	mprintf("commit_request:          %lx\n", journal.j_commit_request);
	mprintf("uuid:                    ");
	for (i = 0; i < sizeof(journal.j_uuid); i++) {
		mprintf("%02x", journal.j_uuid[i]);
	}
	mprintf("\n");
	mprintf("task:                    " FPTR "\n", journal.j_task);
	mprintf("max_transaction_buffers: %x\n", journal.j_max_transaction_buffers);
	mprintf("commit_interval:         %lx\n", journal.j_commit_interval);
	mprintf("commit_timer:            " FPTR "\n", journal.j_commit_timer);
	mprintf("commit_timer_active:     %lx\n", journal.j_commit_timer_active);
	mprintf("revoke:                  " FPTR "\n", journal.j_revoke);
	return 0;
#endif /*CONFIG_JBD*/
}
