/*
 * Copyright (C) 2005 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t ext3_sb_info();
const commandtable_t command_ext3_sb_info =
	{"ext3_sb_info", ext3_sb_info, "address", "print handle_t"};
extern addr_t print_ext3_sb_info();
extern void prhead_ext3_sb_info();

PRIVATE addr_t
ext3_sb_info()
{
	addr_t addr = 0;
	int c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		THROW(usage);
	}

	while (args[optind]) {
		addr = print_ext3_sb_info(getvalue(args[optind]));
		optind++;
	}
	return addr;
}
