#include "crash.h"
#include "flags_sched.h"

extern const commandtable_t
	command_address_space,
	command_bh,
	command_binfmt,
	command_blk_dev_struct,
	command_block_device,
	command_buffer_head,
	command_char_device,
	command_exception_table,
	command_ext2_inode_info,
#if defined(CONFIG_EXT3_FS) || defined(CONFIG_EXT3_FS_MODULE)
	command_ext3_sb_info,
#endif
	command_fib_table,
	command_file,
	command_file_lock,
	command_files_stat,
	command_gendisk,
#if defined(CONFIG_JBD) || defined(CONFIG_JBD_MODULE)
	command_handle,
#endif
	command_inode,
#if defined(CONFIG_JBD) || defined(CONFIG_JBD_MODULE)
	command_journal,
#endif
	command_kmem_cache,
	command_lv,
	command_neighbour,
	command_nfs_inode_info,
	command_nfs_page,
	command_nfs_reqlist,
	command_nfs_server,
	command_nlm_block,
	command_nlm_file,
	command_nlm_rqst,
	command_operations,
	command_page,
	command_pglist_data,
	command_pv,
	command_request_queue,
	command_rtable,
#ifdef _sighand_struct_has_action
	command_sighand_struct,
#else
	command_signal_struct,
#endif
	command_slab,
	command_sock,
	command_socket,
	command_svc_client,
	command_svc_export,
	command_swap_info,
	command_tq_struct,
	command_timer_vec,
	command_tty_struct,
	command_usb_bus,
	command_usb_device,
	command_usb_driver,
	command_user_struct,
	command_vg,
	command_vm_area_struct,
	command_vm_struct,
	command_wait_queue_head,
	command_zone;

const commandtable_t *commandtable_vers[] = {
	&command_address_space,
	&command_bh,
	&command_binfmt,
	&command_blk_dev_struct,
	&command_block_device,
	&command_buffer_head,
#if SUBLEVEL>=5
	&command_char_device,
#endif
	&command_exception_table,
	&command_ext2_inode_info,
#if defined(CONFIG_EXT3_FS) || defined(CONFIG_EXT3_FS_MODULE)
	&command_ext3_sb_info,
#endif
	&command_fib_table,
	&command_file,
	&command_file_lock,
	&command_files_stat,
	&command_gendisk,
#if defined(CONFIG_JBD) || defined(CONFIG_JBD_MODULE)
	&command_handle,
#endif
	&command_inode,
#if defined(CONFIG_JBD) || defined(CONFIG_JBD_MODULE)
	&command_journal,
#endif
	&command_kmem_cache,
#if defined(CONFIG_BLK_DEV_LVM) || defined(CONFIG_BLK_DEV_LVM_MODULE)
	&command_lv,
#endif
	&command_neighbour,
#if defined(CONFIG_NFS_FS) || defined(CONFIG_NFS_FS_MODULE)
	&command_nfs_inode_info,
	&command_nfs_page,
	&command_nfs_reqlist,
	&command_nfs_server,
#endif
#if defined(CONFIG_LOCKD) || defined(CONFIG_LOCKD_MODULE)
	&command_nlm_block,
	&command_nlm_file,
	&command_nlm_rqst,
#endif
	&command_operations,
	&command_page,
	&command_pglist_data,
#if defined(CONFIG_BLK_DEV_LVM) || defined(CONFIG_BLK_DEV_LVM_MODULE)
	&command_pv,
#endif
	&command_request_queue,
	&command_rtable,
#ifdef _sighand_struct_has_action
	&command_sighand_struct,
#else
	&command_signal_struct,
#endif
	&command_slab,
	&command_sock,
	&command_socket,
#if defined(CONFIG_NFSD) || defined(CONFIG_NFSD_MODULE)
	&command_svc_client,
	&command_svc_export,
#endif
	&command_swap_info,
	&command_tq_struct,
	&command_timer_vec,
	&command_tty_struct,
#if defined(CONFIG_USB) || defined(CONFIG_USB_MODULE)
	&command_usb_bus,
	&command_usb_device,
	&command_usb_driver,
#endif
	&command_user_struct,
#if defined(CONFIG_BLK_DEV_LVM) || defined(CONFIG_BLK_DEV_LVM_MODULE)
	&command_vg,
#endif
	&command_vm_area_struct,
	&command_vm_struct,
	&command_wait_queue_head,
	&command_zone,
};
const int ncmdtable_vers = LENGTHOF(commandtable_vers);

void
vers_init()
{
	extern addr_t cache_cache_addr;
	extern addr_t init_task_addr;

	cache_cache_addr = searchaddr_bysym("cache_cache");
	init_task_addr = searchaddr_bysym("init_task_union");
}
