/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/fs.h>
#include <linux/ext2_fs.h>
#ifndef NO_KERNEL_SRC
#include <fs/ext2/ext2.h>
#endif

void
print_ext2_inode_info(addr, iflag)
	addr_t addr;
	int iflag;
{
#ifndef NO_KERNEL_SRC
	struct ext2_inode_info e2i;
	int i;

	if (iflag) {
		addr -= OFFSET(struct ext2_inode_info, vfs_inode);
	}

	mprintf("addr:             " FPTR "\n", addr);
	memread(addr, sizeof(e2i), &e2i, "ext2_inode_info");
	mprintf("data:");
	for (i = 0; i < LENGTHOF(e2i.i_data); i++) {
		mprintf(" %8x", e2i.i_data[i]);
		if (i == 7) {
			mprintf("\n     ");
		}
	}
	mprintf("\n");
	mprintf("flags:            %08x\n", e2i.i_flags);
	mprintf("faddr:            %08x\n", e2i.i_faddr);
	mprintf("frag_no:                %02x\n", e2i.i_frag_no);
	mprintf("frag_size:              %02x\n", e2i.i_frag_size);
	mprintf("state:                %04x\n", e2i.i_state);
	mprintf("file_acl:         %08x\n", e2i.i_file_acl);
	mprintf("dir_acl:          %08x\n", e2i.i_dir_acl);
	mprintf("dtime:            %08x\n", e2i.i_dtime);
	mprintf("block_group:      %08x\n", e2i.i_block_group);
	mprintf("next_alloc_block: %08x\n", e2i.i_next_alloc_block);
	mprintf("next_alloc_goal:  %08x\n", e2i.i_next_alloc_goal);
	mprintf("prealloc_block:   %08x\n", e2i.i_prealloc_block);
	mprintf("prealloc_count:   %08x\n", e2i.i_prealloc_count);
	mprintf("dir_start_lookup: %08x\n", e2i.i_dir_start_lookup);
#ifdef CONFIG_EXT2_FS_POSIX_ACL
	mprintf("acl:              " FPTR "\n", e2i.i_acl);
	mprintf("default_acl:      " FPTR "\n", e2i.i_default_acl);
#endif /*CONFIG_EXT2_FS_POSIX_ACL*/
	mprintf("vfs_inode:        " FPTR "\n", addr + OFFSET(struct ext2_inode_info, vfs_inode));
#endif
}
