/*
 * Copyright (C) 2000-2005 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <asm/semaphore.h>

#if SUBLEVEL>=16
#include <linux/mutex.h>
#endif

void
prhead_semaphore()
{
	mprintf(SPTR"  CNT SLEEP\n", "ADDR");
}

void
mprint_semaphore(semp)
	struct semaphore *semp;
{
	mprintf("%4d %5d", ATOMIC_READ(semp->count), semp->sleepers);
}

addr_t
print_semaphore(addr)
addr_t addr;
{
	struct semaphore sem;

	memread(addr, sizeof(struct semaphore), &sem, "semaphore");
	mprintf(FPTR " ", addr);
	mprint_semaphore(&sem);
	mprintf("\n");
	return ATOMIC_READ(sem.count);
}

#if SUBLEVEL>=16
void
mprint_mutex(mutex)
	struct mutex *mutex;
{
	mprintf("%4d", ATOMIC_READ(mutex->count));
}
#endif
