/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/wait.h>

#include "flags_wait.h"

void
prhead_wait_queue()
{
	mprintf(SPTR" FL "SPTR"\n", "ADDR", "TASK");
}

addr_t
print_wait_queue(addr, full)
	addr_t addr;
	int full;
{
	wait_queue_t wq;

	addr -= OFFSET(wait_queue_t, task_list);
	memread(addr, sizeof(wq), &wq, "wait_queue_t");
	mprintf(FPTR " ", addr);

	mprintf("%02x ", wq.flags);
#ifdef ___wait_queue_has_private
	mprintf(FPTR "\n", wq.private);
#else
	mprintf(FPTR "\n", wq.task);
#endif
	return (addr_t)wq.task_list.next;
}
void
prhead_wait_queue_head()
{
}

addr_t
print_wait_queue_head(addr, full)
	addr_t addr;
	int full;
{
	wait_queue_head_t wqh;
	addr_t waddr;

	memread(addr, sizeof(wqh), &wqh, "wait_queue_head_t");
	mprintf(FPTR "\n", addr);

	prhead_wait_queue();
	waddr = (addr_t)wqh.task_list.next;
	while (waddr && waddr != addr + OFFSET(wait_queue_head_t, task_list)) {
		waddr = print_wait_queue(waddr, full);
	}

	return 0;
}
