/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include <sys/stat.h>
#include <unistd.h>
#include "crash.h"

PRIVATE addr_t csocket(), sock();
const commandtable_t command_socket =
	{"socket", csocket, "address", "print socket table"};
const commandtable_t command_sock =
	{"sock", sock, "[-f] [address]", "print sock table"};

extern addr_t print_socket();
extern addr_t print_sock();
extern addr_t print_listed_sock();
extern void prhead_sock();

addr_t tcp_hashinfo_addr, udp_hash_addr, unix_socket_table_addr;

PRIVATE addr_t
csocket()
{
	addr_t addr;
	int i, c;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		THROW(usage);
	}

	if (optind == argcnt) {
		THROW(usage);
	}
	for (i = optind; i < argcnt; i++) {
		if (i > optind)
			mprintf("\n");
		addr = getvalue(args[i]);
		print_socket(addr);
	}
	return 0;
}

PRIVATE addr_t
sock()
{
	addr_t addr = 0;
	int i, c;
	int fflag = 0;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			fflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (optind == argcnt) {
		GETADDR(tcp_hashinfo);
		GETADDR(udp_hash);
		GETADDR(unix_socket_table);
		return print_listed_sock(fflag, tcp_hashinfo_addr, udp_hash_addr, unix_socket_table_addr);
	}

	prhead_sock();
	for (i = optind; i < argcnt; i++) {
		if (i > optind)
			mprintf("\n");
		addr = getvalue(args[i]);
		addr = print_sock(addr, fflag);
	}
	return addr;
}
