/*
 * Copyright (C) 2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/param.h>
#include <asm/page.h>

void
mprint_HZ()
{
	mprintf("%d", HZ);
}

void
mprint_jif(jif)
	unsigned long jif;
{
	unsigned long day, hour, min, sec;

	day =  jif / (HZ*60*60*24);
	jif -= day * (HZ*60*60*24);
	hour = jif / (HZ*60*60);
	jif -= hour* (HZ*60*60);
	min  = jif / (HZ*60);
	jif -= min * (HZ*60);
	sec  = jif / (HZ);
	jif -= sec * (HZ);

	mprintf("%3ldd %02ld:%02ld:%02ld", day, hour, min, sec);
#if 1000 % HZ == 0
	mprintf(".%03ld", jif*(1000/HZ));
#else
	mprintf(".%03d", (int)(jif*(1000.0/HZ)));
#endif
}

addr_t get_page_offset()
{
#ifdef __START_KERNEL_map /*x86_64*/
	return (addr_t)__START_KERNEL_map;
#else
	return (addr_t)PAGE_OFFSET;
#endif
}
