/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"
#include <linux/sys.h>
#if LINUXVER>=25
#include <asm/unistd.h>
#endif

PRIVATE addr_t sys_call();
const commandtable_t command_sys_call_table =
	{"sys_call_table", sys_call, "", "print system call jump table"};

addr_t sys_call_table_addr;

PRIVATE addr_t
sys_call()
{
	int full;
	int i, c;
	const char *p;
#ifndef NR_syscalls	/*XXX*/
#define NR_syscalls 256
#endif
	addr_t table[NR_syscalls];

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			full = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (optind != argcnt) {
		THROW(usage);
	}

	GETADDR(sys_call_table);
	memread(sys_call_table_addr, sizeof(table), table, "sys_call_table");

	for (i = 0; i < NR_syscalls; i++) {
		mprintf("%3d  %8lx", i, table[i]);
		p = getsymstr(table[i]);
		mprintf("  %s\n", p? p: "-");
	}
	return 0;
}
