/*
 * Copyright (C) 2000-2003 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <xfs.h>
#include <xfs_inum.h>
#include <xfs_log.h>
#include <xfs_trans.h>
#include <xfs_sb.h>
#ifdef HAVE_XFS_DIR1
#include <xfs_dir.h>
#endif
#include <xfs_dir2.h>
#include <xfs_dmapi.h>
#include <xfs_mount.h>
#include <xfs_bmap_btree.h>
#include <xfs_attr_sf.h>
#ifdef HAVE_XFS_DIR1
#include <xfs_dir_sf.h>
#endif
#include <xfs_dir2_sf.h>
#include <xfs_dinode.h>
#include <xfs_inode.h>
#include <xfs_quota.h>

#include "flags_mount.h"

#define	IFLAG	1
#define	LFLAG	2
#define HFLAG	4

extern void prhead_xfs_inode();
extern void prhead_xfs_log_item();
extern addr_t print_xfs_inode();
extern addr_t print_xfs_log_item();

addr_t
print_xfs_mount(addr, flag)
	addr_t addr;
	int flag;
{
	xfs_mount_t m;
	char name[32];
	int i;
	static const struct bitname qflags[] = {
		{ XFS_UQUOTA_ACCT,	"uquota_acct" },
		{ XFS_UQUOTA_ENFD,	"uquota_enfd" },
		{ XFS_UQUOTA_CHKD,	"uquota_chkd" },
		{ XFS_PQUOTA_ACCT,	"pquota_acct" },
#ifdef XFS_OQUOTA_ENFD
		{ XFS_OQUOTA_ENFD,	"oquota_enfd" },
#endif
#ifdef XFS_OQUOTA_CHKD
		{ XFS_OQUOTA_CHKD,	"oquota_chkd" },
#endif
#ifdef XFS_GQUOTA_ENFD
		{ XFS_GQUOTA_ENFD,	"gquota_enfd" },
#endif
#ifdef XFS_GQUOTA_CHKD
		{ XFS_GQUOTA_CHKD,	"gquota_chkd" },
#endif
		{ XFS_GQUOTA_ACCT,	"gquota_acct" },

		{ XFS_UQUOTA_ACTIVE,	"uquota_active" },
#ifdef XFS_PQUOTA_ACTIVE
		{ XFS_PQUOTA_ACTIVE,	"pquota_active" },
#endif
		{ XFS_GQUOTA_ACTIVE,	"gquota_active" },
#ifdef XFS_QUOTA_MAYBE
		{ XFS_QUOTA_MAYBE,	"quota_maybe" },
#endif
		{ 0,			NULL }
	};

	mprintf("addr         " FPTR "  (%x)\n", addr, sizeof(m));
	memread(addr, sizeof(m), &m, "xfs_mount_t");

	mprintf("ail          ");
	if ((addr_t)m.m_ail.ail_forw == addr + OFFSET(struct xfs_mount, m_ail)
	 && (addr_t)m.m_ail.ail_back == addr + OFFSET(struct xfs_mount, m_ail))
		mprintf(SPTR " " SPTR, "-", "-");
	else
		mprintf(FPTR " " FPTR, m.m_ail.ail_forw, m.m_ail.ail_back);
	mprintf("  (xfs_log_item)\n");
	mprintf("ail_gen        %x\n", m.m_ail_gen);
	mprintf("sb.agblocks    %lx\n",  m.m_sb.sb_agblocks);
	mprintf("sb.agcount     %x\n",   m.m_sb.sb_agcount);
	mprintf("sb.icount      %llx\n", m.m_sb.sb_icount);
	mprintf("sb.ifree       %llx\n", m.m_sb.sb_ifree);
	mprintf("sb.fdblocks    %llx\n", m.m_sb.sb_fdblocks);
	mprintf("sb.frextents   %llx\n", m.m_sb.sb_frextents);
	mprintf("sb.uuid      ");
	for (i = 0; i < sizeof(m.m_sb.sb_uuid); i++) {
		mprintf("%02x", *((unsigned char *)&m.m_sb.sb_uuid + i));
	}
	mprintf("\n");
	mprintf("sb.uquotino    %lx\n",  m.m_sb.sb_uquotino);
	mprintf("sb.gquotino    %lx\n",  m.m_sb.sb_gquotino);
	mprintf("sb_bp        " FPTR "  (page_buf)\n", m.m_sb_bp);
	mprintf("fsname       " FPTR "  \"", m.m_fsname);
	memread((addr_t)m.m_fsname, sizeof(name), name, "xfs_mount.m_fsname");
	mprintstr(name, sizeof(name));
	mprintf("\"\n");
	mprintf("bsize          %x\n", m.m_bsize);
	mprintf("agfrotor       %x  %x\n", m.m_agfrotor, m.m_agirotor);
	mprintf("ihsize         %x\n", m.m_ihsize);
	mprintf("ihash        " FPTR "\n", m.m_ihash);
	mprintf("inodes       " FPTR "  (xfs_inode)\n", m.m_inodes);
	mprintf("ireclaims      %x\n", m.m_ireclaims);
	mprintf("readio_log     %x\n", m.m_readio_log);
	mprintf("readio_blocks  %x\n", m.m_readio_blocks);
	mprintf("writeio_log    %x\n", m.m_writeio_log);
	mprintf("writeio_blocks %x\n", m.m_writeio_blocks);
	mprintf("log          " FPTR "  (xlog)\n", m.m_log);
	mprintf("logbufs        %x\n", m.m_logbufs);
	mprintf("logbsize       %x\n", m.m_logbsize);
	mprintf("rbmip        " FPTR "  (xfs_inode)\n", m.m_rbmip);
	mprintf("rsumip       " FPTR "  (xfs_inode)\n", m.m_rsumip);
	mprintf("rootip       " FPTR "  (xfs_inode)\n", m.m_rootip);
	mprintf("quotainfo    " FPTR "  (xfs_quotainfo)\n", m.m_quotainfo);
#ifdef _xfs_mount_has_m_logdev_targp
	/* new style */
	mprintf("ddev_targp   " FPTR "  (xfs_buftarg)\n", m.m_ddev_targp);
	mprintf("logdev_targp " FPTR "  (xfs_buftarg)\n", m.m_logdev_targp);
#else
	/* old fashion */
	mprintf("ddev_targ    " FPTR " " FPTR " %04x\n",
		m.m_ddev_targ.pb_targ, m.m_ddev_targ.bd_targ, m.m_ddev_targ.dev);
	mprintf("logdev_targ  " FPTR " " FPTR " %04x\n",
		m.m_logdev_targ.pb_targ, m.m_logdev_targ.bd_targ, m.m_logdev_targ.dev);
#endif
	mprintf("perag        " FPTR "  (xfs_perag)\n", m.m_perag);
	mprintf("flags          %x  ", m.m_flags);
	mprintbit(mflags, m.m_flags);
	mprintf("\n");
	mprintf("qflags         %x  ", m.m_qflags);
	mprintbit(qflags, m.m_qflags);
	mprintf("\n");

	if (flag & HFLAG) {
		int n;
		mprintf("XFS_INODE HASH\n");
		prhead_xfs_inode();
		for (n = 0; n < m.m_ihsize; n++) {
			struct xfs_ihash hash;
			addr_t tmp;
			memread((addr_t)m.m_ihash + sizeof(hash) * n, sizeof(hash), &hash, "xfs_ihash");
			tmp = (addr_t)hash.ih_next;
			while (tmp) {
				tmp = print_xfs_inode(tmp, 0, 1);
			}
		}
		prhead_xfs_inode();
	}

	if (flag & IFLAG) {
		addr_t top, tmp;

		tmp = top = (addr_t)m.m_inodes;
		mprintf("XFS_INODE\n");
		prhead_xfs_inode();
		while (tmp) {
			tmp = print_xfs_inode(tmp, 0, 0);
			if (tmp == top)
				break;
		}
		prhead_xfs_inode();
	}

	if (flag & LFLAG) {
		addr_t tmp = (addr_t)m.m_ail.ail_forw;
		mprintf("AIL\n");
		prhead_xfs_log_item();
		while (tmp && tmp != addr + OFFSET(xfs_mount_t, m_ail)) {
			tmp = print_xfs_log_item(tmp, 0);
		}
	}

	return 0;
}
