/*
 * Copyright (C) 2000-2007 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t pagebuf(), xfs_buftarg();
const commandtable_t command_pagebuf =
	{"page_buf", pagebuf, "[-a] [-f] [-t buftarg] [address]", "[XFS] print page_buf_t table\n  -a  follow next\n  -f  more detail"};
const commandtable_t command_xfs_buftarg =
	{"xfs_buftarg", xfs_buftarg, "[-b] address", "[XFS] print xfs_buftarg table\n  -b  show pagebuf from hash"};

extern void prhead_pagebuf();
extern addr_t print_pagebuf();
extern void print_all_pagebuf();
extern addr_t print_pagebuf_target();

addr_t pbhash_addr;

PRIVATE addr_t
pagebuf()
{
	int i, c;
	addr_t start, addr = 0;
	int aflag = 0, fflag = 0;
	addr_t target = 0;

	while ((c = getopt(argcnt, args, "aft:")) != EOF) {
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		case 'f':
			fflag = 1;
			break;
		case 't':
			target = getvalue(optarg);
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		prhead_pagebuf();
		for (i = optind; i < argcnt; i++) {
			start = addr = getvalue(args[i]);
			do {
				addr = print_pagebuf(addr, fflag);
			} while (aflag && addr && start != addr);
		}
	} else if (target) {
		prhead_pagebuf();
		addr = print_pagebuf_target(target);
	} else {
		GETADDR(pbhash);
		print_all_pagebuf(pbhash_addr, fflag, 0);
	}
	return addr;
}

PRIVATE addr_t
xfs_buftarg()
{
	int i, c;
	addr_t start, addr = 0;
	int bflag = 0;

	while ((c = getopt(argcnt, args, "b")) != EOF) {
		switch (c) {
		case 'b':
			bflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt > optind) {
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			addr = print_xfs_buftarg(addr, bflag);
		}
	} else {
		THROW(usage);
	}
	return addr;
}
