/*
 * Copyright (C) 2000-2005 ASANO Masahiro
 */

#include <unistd.h>
#include "crash.h"

PRIVATE addr_t xfs_dquot(), xfs_dqhash(), xfs_quotainfo(), xfs_qm();
const commandtable_t command_xfs_dquot =
	{"xfs_dquot", xfs_dquot, "[-f] [address]", "[XFS] print xfs_dquot table\n\n  -f  more detail"};
const commandtable_t command_xfs_dqhash =
	{"xfs_dqhash", xfs_dqhash, "address [size]", "[XFS] print xfs_dqhash table\n\n  -f  more detail"};
const commandtable_t command_xfs_quotainfo =
	{"xfs_quotainfo", xfs_quotainfo, "address", "[XFS] print xfs_quotainfo table"};
const commandtable_t command_xfs_qm =
	{"xfs_qm", xfs_qm, "[address]", "[XFS] print xfs_qm table"};

extern void prhead_xfs_dquot();
extern addr_t print_xfs_dquot();
extern void print_all_xfs_dquot();

addr_t xfs_Gqm_addr;

PRIVATE addr_t
xfs_dquot()
{
	int i, c;
	addr_t start, addr = 0;
	int aflag = 0, fflag = 0;

	while ((c = getopt(argcnt, args, "af")) != EOF) {
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		case 'f':
			fflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}

	for (i = optind; i < argcnt; i++) {
		start = addr = getvalue(args[i]);
		do {
			addr = print_xfs_dquot(addr, fflag);
		} while (aflag && addr && start != addr);
	}

	return addr;
}

PRIVATE addr_t
xfs_dqhash()
{
	int i, c;
	addr_t start, addr = 0;
	int n = 1, aflag = 0;

	while ((c = getopt(argcnt, args, "a")) != EOF) {
		switch (c) {
		case 'a':
			aflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	switch (argcnt - optind) {
	case 2:
		n = getvalue(args[optind + 1]);
	case 1:
		start = getvalue(args[optind]);
		break;
	default:
		THROW(usage);
	}

	prhead_xfs_dqhash();
	for (i = 0; i < n; i++) {
		addr = print_xfs_dqhash(start, i, 0);
	}

	return addr;
}

PRIVATE addr_t
xfs_quotainfo()
{
	int i, c;
	addr_t addr = 0;

	while ((c = getopt(argcnt, args, "")) != EOF) {
		switch (c) {
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		THROW(usage);
	}
	for (i = optind; i < argcnt; i++) {
		addr = getvalue(args[i]);
		addr = print_xfs_quotainfo(addr, 0);
	}
	return addr;
}

PRIVATE addr_t
xfs_qm()
{
	int i, c;
	int fflag = 0;
	addr_t addr, xfs_Gqm;

	while ((c = getopt(argcnt, args, "f")) != EOF) {
		switch (c) {
		case 'f':
			fflag = 1;
			break;
		default:
			THROW(usage);
		}
	}

	if (argcnt == optind) {
		GETADDR(xfs_Gqm);
		memread(xfs_Gqm_addr, sizeof(xfs_Gqm), &xfs_Gqm, "xfs_Gqm");
		addr = print_xfs_qm(xfs_Gqm, fflag);
	} else {
		for (i = optind; i < argcnt; i++) {
			addr = getvalue(args[i]);
			addr = print_xfs_qm(addr, fflag);
		}
	}
	return addr;
}
