/*
 * Copyright (C) 2000-2002 ASANO Masahiro
 */

#include "def.h"

#define __KERNEL__
#include <linux/mm.h>

const char head_page[] = "    ADDR  MAPPING  INDEX CNT     WAIT  BUFFERS  FLAGS\n";

addr_t
print_page(addr)
	addr_t addr;
{
	struct page pg;
	static const struct bitname pgflags[] = {
		{ 1<<PG_locked,		"locked" },
		{ 1<<PG_error,		"error" },
		{ 1<<PG_referenced,	"referenced" },
		{ 1<<PG_dirty,		"dirty" },
		{ 1<<PG_uptodate,	"uptodate" },
		{ 1<<PG_free_after,	"free_after" },
		{ 1<<PG_decr_after,	"dcer_after" },
		{ 1<<PG_swap_unlock_after,"swap_unlock_after" },
		{ 1<<PG_DMA,		"DMA" },
		{ 1<<PG_Slab,		"Slab" },
		{ 1<<PG_swap_cache,	"swap_cache" },
		{ 1<<PG_skip,		"skip" },
		{ 1<<PG_reserved,	"reserved" },
		{ 0,			NULL }
	};

	memread(addr, sizeof(pg), &pg, "page");
	mprintf("%8lx ", addr);

	mprintf("%8lx %6lx %3d %8lx %8lx ",
		pg.inode, pg.offset, pg.count.counter, pg.wait, pg.buffers);
	mprintbit(pgflags, pg.flags);
	mprintf("\n");
	return (addr_t)pg.next_hash;
}

addr_t
print_vm_area_struct(addr)
addr_t addr;
{
	struct vm_area_struct vma;
	static const struct bitname vmflags[] = {
		{ VM_READ,	"read" },
		{ VM_WRITE,	"write" },
		{ VM_EXEC,	"exec" },
		{ VM_SHARED,	"shared" },

		{ VM_MAYREAD,	"mayread" },
		{ VM_MAYWRITE,	"maywrite" },
		{ VM_MAYEXEC,	"mayexec" },
		{ VM_MAYSHARE,	"mayshare" },

		{ VM_GROWSDOWN,	"growsdown" },
		{ VM_GROWSUP,	"growsup" },
		{ VM_SHM,	"shm" },
		{ VM_DENYWRITE,	"denywrite" },

		{ VM_EXECUTABLE,"executable" },
		{ VM_LOCKED,	"locked" },
		{ VM_IO,	"io" },
		{ 0,		NULL }
	};

	memread(addr, sizeof(vma), &vma, "vm_area_struct");
	mprintf("addr:          %8lx\n", addr);

	mprintf("vm_mm:         %8lx\n", vma.vm_mm);
	mprintf("vm_start:      %8lx\n", vma.vm_start);
	mprintf("vm_end:        %8lx\n", vma.vm_end);
	mprintf("vm_next:       %8lx\n", vma.vm_next);
	mprintf("vm_flags:     ");
	mprintbit(vmflags, vma.vm_flags);
	mprintf("\n");
	mprintf("vm_avl_height: %8d\n",  vma.vm_avl_height);
	mprintf("vm_avl_left:   %8lx\n", vma.vm_avl_left);
	mprintf("vm_avl_right:  %8lx\n", vma.vm_avl_right);
	mprintf("vm_next_share: %8lx\n", vma.vm_next_share);
	mprintf("vm_file:       %8lx\n", vma.vm_file);
	return 0;
}
